/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.database.ddl.flow.property;

import cn.schoolwow.quickdao.domain.database.parent.DatabaseType;
import cn.schoolwow.quickdao.domain.entity.Entity;
import cn.schoolwow.quickdao.domain.entity.Property;
import cn.schoolwow.quickdao.module.database.ddl.flow.property.getEntityProperty.GetEntityPropertyByH2Flow;
import cn.schoolwow.quickdao.module.database.ddl.flow.property.getEntityProperty.GetEntityPropertyByMySQLFlow;
import cn.schoolwow.quickdao.module.database.ddl.flow.property.getEntityProperty.GetEntityPropertyByOracleFlow;
import cn.schoolwow.quickdao.module.database.ddl.flow.property.getEntityProperty.GetEntityPropertyByPostgresFlow;
import cn.schoolwow.quickdao.module.database.ddl.flow.property.getEntityProperty.GetEntityPropertyBySQLServerFlow;
import cn.schoolwow.quickdao.module.database.ddl.flow.property.getEntityProperty.GetEntityPropertyBySQLiteFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class GetEntityPropertyFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        DatabaseType databaseType = (DatabaseType)((Object)flowContext.checkData("databaseType"));
        switch (databaseType) {
            case H2: {
                flowContext.executeFlowList(new BusinessFlow[]{new GetEntityPropertyByH2Flow()});
                break;
            }
            case SQLite: {
                flowContext.executeFlowList(new BusinessFlow[]{new GetEntityPropertyBySQLiteFlow()});
                break;
            }
            case Mysql: 
            case MariaDB: {
                flowContext.executeFlowList(new BusinessFlow[]{new GetEntityPropertyByMySQLFlow()});
                break;
            }
            case Postgresql: {
                flowContext.executeFlowList(new BusinessFlow[]{new GetEntityPropertyByPostgresFlow()});
                break;
            }
            case SQLServer: {
                flowContext.executeFlowList(new BusinessFlow[]{new GetEntityPropertyBySQLServerFlow()});
                break;
            }
            case Oracle: {
                flowContext.executeFlowList(new BusinessFlow[]{new GetEntityPropertyByOracleFlow()});
            }
        }
        Entity entity = (Entity)flowContext.checkData("entity");
        for (Property property : entity.properties) {
            if (!property.columnType.contains("(") || !property.columnType.contains(")")) continue;
            property.range = property.columnType.substring(property.columnType.indexOf("(") + 1, property.columnType.indexOf(")"));
            property.columnType = property.columnType.substring(0, property.columnType.indexOf("("));
        }
    }

    public String name() {
        return "\u83b7\u53d6\u6570\u636e\u5e93\u8868\u5b57\u6bb5\u5217\u8868";
    }
}

