/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.database.ddl.flow.property;

import cn.schoolwow.quickdao.domain.database.parent.DatabaseType;
import cn.schoolwow.quickdao.domain.entity.Entity;
import cn.schoolwow.quickdao.domain.entity.Property;
import cn.schoolwow.quickdao.module.database.ddl.flow.property.getEntityPropertyList.GetEntityPropertyListByH2Flow;
import cn.schoolwow.quickdao.module.database.ddl.flow.property.getEntityPropertyList.GetEntityPropertyListByMySQLFlow;
import cn.schoolwow.quickdao.module.database.ddl.flow.property.getEntityPropertyList.GetEntityPropertyListByOracleFlow;
import cn.schoolwow.quickdao.module.database.ddl.flow.property.getEntityPropertyList.GetEntityPropertyListByPostgresFlow;
import cn.schoolwow.quickdao.module.database.ddl.flow.property.getEntityPropertyList.GetEntityPropertyListBySQLServerFlow;
import cn.schoolwow.quickdao.module.database.ddl.flow.property.getEntityPropertyList.GetEntityPropertyListBySQLiteFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.util.List;

public class GetEntityPropertyListFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        DatabaseType databaseType = (DatabaseType)((Object)flowContext.checkData("databaseType"));
        flowContext.putTemporaryData("name", (Object)"\u83b7\u53d6\u6570\u636e\u5e93\u8868\u5b57\u6bb5\u5217\u8868");
        switch (databaseType) {
            case H2: {
                flowContext.executeFlowList(new BusinessFlow[]{new GetEntityPropertyListByH2Flow()});
                break;
            }
            case SQLite: {
                flowContext.executeFlowList(new BusinessFlow[]{new GetEntityPropertyListBySQLiteFlow()});
                break;
            }
            case Mysql: 
            case MariaDB: {
                flowContext.executeFlowList(new BusinessFlow[]{new GetEntityPropertyListByMySQLFlow()});
                break;
            }
            case Postgresql: {
                flowContext.executeFlowList(new BusinessFlow[]{new GetEntityPropertyListByPostgresFlow()});
                break;
            }
            case SQLServer: {
                flowContext.executeFlowList(new BusinessFlow[]{new GetEntityPropertyListBySQLServerFlow()});
                break;
            }
            case Oracle: {
                flowContext.executeFlowList(new BusinessFlow[]{new GetEntityPropertyListByOracleFlow()});
            }
        }
        List entityList = (List)flowContext.checkData("entityList");
        for (Entity entity : entityList) {
            for (Property property : entity.properties) {
                if (!property.columnType.contains("(") || !property.columnType.contains(")")) continue;
                property.range = property.columnType.substring(property.columnType.indexOf("(") + 1, property.columnType.indexOf(")"));
                property.columnType = property.columnType.substring(0, property.columnType.indexOf("("));
            }
        }
    }

    public String name() {
        return "\u83b7\u53d6\u6570\u636e\u5e93\u6240\u6709\u8868\u5b57\u6bb5\u5217\u8868";
    }
}

