/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.database.ddl.flow.property;

import cn.schoolwow.quickdao.domain.database.parent.DatabaseType;
import cn.schoolwow.quickdao.domain.entity.Property;
import cn.schoolwow.quickdao.module.database.ddl.flow.property.getProperty.GetPropertyByH2Flow;
import cn.schoolwow.quickdao.module.database.ddl.flow.property.getProperty.GetPropertyByMySQLFlow;
import cn.schoolwow.quickdao.module.database.ddl.flow.property.getProperty.GetPropertyByOracleFlow;
import cn.schoolwow.quickdao.module.database.ddl.flow.property.getProperty.GetPropertyByPostgresFlow;
import cn.schoolwow.quickdao.module.database.ddl.flow.property.getProperty.GetPropertyBySQLServerFlow;
import cn.schoolwow.quickdao.module.database.ddl.flow.property.getProperty.GetPropertyBySQLiteFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class GetPropertyFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        DatabaseType databaseType = (DatabaseType)((Object)flowContext.checkData("databaseType"));
        switch (databaseType) {
            case H2: {
                flowContext.executeFlowList(new BusinessFlow[]{new GetPropertyByH2Flow()});
                break;
            }
            case SQLite: {
                flowContext.executeFlowList(new BusinessFlow[]{new GetPropertyBySQLiteFlow()});
                break;
            }
            case Mysql: 
            case MariaDB: {
                flowContext.executeFlowList(new BusinessFlow[]{new GetPropertyByMySQLFlow()});
                break;
            }
            case Postgresql: {
                flowContext.executeFlowList(new BusinessFlow[]{new GetPropertyByPostgresFlow()});
                break;
            }
            case SQLServer: {
                flowContext.executeFlowList(new BusinessFlow[]{new GetPropertyBySQLServerFlow()});
                break;
            }
            case Oracle: {
                flowContext.executeFlowList(new BusinessFlow[]{new GetPropertyByOracleFlow()});
            }
        }
        Property property = (Property)flowContext.getData("property");
        if (null != property && property.columnType.contains("(") && property.columnType.contains(")")) {
            property.range = property.columnType.substring(property.columnType.indexOf("(") + 1, property.columnType.indexOf(")"));
            property.columnType = property.columnType.substring(0, property.columnType.indexOf("("));
        }
    }

    public String name() {
        return "\u83b7\u53d6\u6570\u636e\u5e93\u8868\u5b57\u6bb5\u5217\u8868";
    }
}

