/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.database.ddl.flow.property.getEntityProperty;

import cn.schoolwow.quickdao.annotation.IdStrategy;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.entity.Entity;
import cn.schoolwow.quickdao.domain.entity.Property;
import cn.schoolwow.quickdao.module.database.parent.domain.ResultSetConsumer;
import cn.schoolwow.quickdao.module.database.parent.flow.executor.ExecuteQueryConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.domain.FlowDataFeature;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.sql.ResultSet;
import java.util.Arrays;

public class GetEntityPropertyByMySQLFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkInstanceData(QuickDAOConfig.class);
        final Entity entity = (Entity)flowContext.checkData("entity");
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u83b7\u53d6\u6307\u5b9a\u8868\u5b57\u6bb5\u4fe1\u606f").putTemporaryData("sql", (Object)("select column_name, column_type, character_maximum_length, numeric_precision, is_nullable, column_key, extra, column_default, column_comment from information_schema.`columns` where table_schema = '" + quickDAOConfig.databaseContext.databaseName + "' and table_name = ? order by table_name asc, ordinal_position asc;")).putTemporaryData("parameters", Arrays.asList(entity.tableName)).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    Property property = new Property();
                    property.column = resultSet.getString("column_name");
                    property.columnType = resultSet.getString("column_type");
                    property.notNull = "NO".equals(resultSet.getString("is_nullable"));
                    String key = resultSet.getString("column_key");
                    if ("PRI".equals(key)) {
                        property.id = true;
                    }
                    if ("auto_increment".equals(resultSet.getString("extra"))) {
                        property.id = true;
                        property.strategy = IdStrategy.AutoIncrement;
                    } else {
                        property.strategy = IdStrategy.None;
                    }
                    if (null != resultSet.getString("column_default")) {
                        property.defaultValue = resultSet.getString("column_default");
                        if (!property.defaultValue.contains("CURRENT_TIMESTAMP") && !property.defaultValue.contains("'")) {
                            property.defaultValue = "'" + property.defaultValue + "'";
                        }
                    }
                    property.comment = resultSet.getString("column_comment").replace("\"", "\\\"");
                    entity.properties.add(property);
                }
            }
        }, new FlowDataFeature[0]).execute();
    }

    public String name() {
        return "\u83b7\u53d6\u6570\u636e\u5e93\u8868\u6307\u5b9a\u5b57\u6bb5-MySQL\u6570\u636e\u5e93";
    }
}

