/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.database.ddl.flow.property.getEntityProperty;

import cn.schoolwow.quickdao.domain.entity.Entity;
import cn.schoolwow.quickdao.domain.entity.Property;
import cn.schoolwow.quickdao.module.database.parent.domain.ResultSetConsumer;
import cn.schoolwow.quickdao.module.database.parent.flow.executor.ExecuteQueryConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.domain.FlowDataFeature;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.sql.ResultSet;
import java.util.Arrays;

public class GetEntityPropertyByOracleFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        final Entity entity = (Entity)flowContext.checkData("entity");
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u83b7\u53d6\u6307\u5b9a\u8868\u5b57\u6bb5\u4fe1\u606f").putTemporaryData("sql", (Object)"select column_name, data_type, nullable, data_length from user_tab_columns where table_name = ?").putTemporaryData("parameters", Arrays.asList(entity.tableName)).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    Property property = new Property();
                    property.column = resultSet.getString("column_name");
                    property.columnType = resultSet.getString("data_type");
                    if (property.columnType.contains(" ")) {
                        property.columnType = property.columnType.substring(0, property.columnType.indexOf(" "));
                    }
                    String dataLength = resultSet.getString("data_length");
                    if (property.columnType.toLowerCase().contains("char") && null != dataLength && !dataLength.isEmpty()) {
                        property.columnType = property.columnType + "(" + dataLength + ")";
                    }
                    property.notNull = "N".equals(resultSet.getString("nullable"));
                    entity.properties.add(property);
                }
            }
        }, new FlowDataFeature[0]).execute();
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u83b7\u53d6\u6307\u5b9a\u8868\u5b57\u6bb5\u6ce8\u91ca").putTemporaryData("sql", (Object)"select column_name, comments from user_col_comments where table_name = ?").putTemporaryData("parameters", Arrays.asList(entity.tableName)).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    String columnName = resultSet.getString("column_name");
                    for (Property property : entity.properties) {
                        if (!property.column.equalsIgnoreCase(columnName)) continue;
                        property.comment = resultSet.getString("comments");
                    }
                }
            }
        }, new FlowDataFeature[0]).execute();
    }

    public String name() {
        return "\u83b7\u53d6\u6570\u636e\u5e93\u8868\u6307\u5b9a\u5b57\u6bb5-Oracle\u6570\u636e\u5e93";
    }
}

