/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.database.ddl.flow.property.getEntityProperty;

import cn.schoolwow.quickdao.annotation.IdStrategy;
import cn.schoolwow.quickdao.domain.entity.Entity;
import cn.schoolwow.quickdao.domain.entity.Property;
import cn.schoolwow.quickdao.module.database.parent.domain.ResultSetConsumer;
import cn.schoolwow.quickdao.module.database.parent.flow.executor.ExecuteQueryConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.domain.FlowDataFeature;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.sql.ResultSet;
import java.util.Arrays;

public class GetEntityPropertyBySQLServerFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        final Entity entity = (Entity)flowContext.checkData("entity");
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u83b7\u53d6\u6307\u5b9a\u8868\u5b57\u6bb5\u7c7b\u578b\u4fe1\u606f").putTemporaryData("sql", (Object)"select ordinal_position,column_name,data_type,is_nullable,character_maximum_length from information_schema.columns where table_name = ?;").putTemporaryData("parameters", Arrays.asList(entity.tableName)).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    Property property = new Property();
                    property.column = resultSet.getString("column_name");
                    property.columnType = resultSet.getString("data_type");
                    property.notNull = "NO".equals(resultSet.getString("is_nullable"));
                    entity.properties.add(property);
                }
            }
        }, new FlowDataFeature[0]).execute();
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u83b7\u53d6\u6307\u5b9a\u8868\u5b57\u6bb5\u6ce8\u91ca").putTemporaryData("sql", (Object)"select c.name column_name, convert(varchar(255),a.value) value from sys.extended_properties a, sysobjects b, sys.columns c where a.major_id = b.id and c.object_id = b.id and c.column_id = a.minor_id and b.name = ?;").putTemporaryData("parameters", Arrays.asList(entity.tableName)).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    String columnName = resultSet.getString("column_name");
                    for (Property property : entity.properties) {
                        if (!property.column.equalsIgnoreCase(columnName)) continue;
                        property.comment = resultSet.getString("value");
                    }
                }
            }
        }, new FlowDataFeature[0]).execute();
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u83b7\u53d6\u6307\u5b9a\u8868\u4e3b\u952e").putTemporaryData("sql", (Object)"select column_name from information_schema.key_column_usage where table_name = ?").putTemporaryData("parameters", Arrays.asList(entity.tableName)).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    String columnName = resultSet.getString("column_name");
                    for (Property property : entity.properties) {
                        if (!property.column.equalsIgnoreCase(columnName)) continue;
                        property.id = true;
                        property.strategy = IdStrategy.AutoIncrement;
                    }
                }
            }
        }, new FlowDataFeature[0]).execute();
    }

    public String name() {
        return "\u83b7\u53d6\u6570\u636e\u5e93\u8868\u6307\u5b9a\u5b57\u6bb5-SQLServer\u6570\u636e\u5e93";
    }
}

