/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.database.ddl.flow.property.getEntityProperty;

import cn.schoolwow.quickdao.annotation.IdStrategy;
import cn.schoolwow.quickdao.domain.entity.Entity;
import cn.schoolwow.quickdao.domain.entity.Property;
import cn.schoolwow.quickdao.module.database.parent.domain.ResultSetConsumer;
import cn.schoolwow.quickdao.module.database.parent.flow.executor.ExecuteQueryConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.domain.FlowDataFeature;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.sql.ResultSet;
import java.util.Arrays;

public class GetEntityPropertyBySQLiteFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        this.setPropertyInfo(flowContext);
        this.setPropertyForeignKey(flowContext);
    }

    public String name() {
        return "\u83b7\u53d6\u6570\u636e\u5e93\u8868\u6307\u5b9a\u5b57\u6bb5-SQLite\u6570\u636e\u5e93";
    }

    private void setPropertyInfo(FlowContext flowContext) {
        final Entity entity = (Entity)flowContext.checkData("entity");
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u83b7\u53d6\u8868\u6307\u5b9a\u5b57\u6bb5\u4fe1\u606f").putTemporaryData("sql", (Object)("PRAGMA table_info(`" + entity.tableName + "`);")).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    Property property = new Property();
                    property.column = resultSet.getString("name");
                    property.columnType = resultSet.getString("type");
                    property.notNull = "1".equals(resultSet.getString("notnull"));
                    if (null != resultSet.getString("dflt_value")) {
                        property.defaultValue = resultSet.getString("dflt_value");
                    }
                    if (1 == resultSet.getInt("pk")) {
                        property.id = true;
                        property.strategy = IdStrategy.AutoIncrement;
                    }
                    entity.properties.add(property);
                }
            }
        }, new FlowDataFeature[0]).execute();
    }

    private void setPropertyForeignKey(FlowContext flowContext) {
        final Entity entity = (Entity)flowContext.checkData("entity");
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u83b7\u53d6\u5355\u4e2a\u8868\u5b57\u6bb5\u5916\u952e\u4fe1\u606f").putTemporaryData("sql", (Object)"select name,sql from sqlite_master where type='table' and name = ?;").putTemporaryData("parameters", Arrays.asList(entity.tableName)).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    if (!entity.tableName.equalsIgnoreCase(resultSet.getString("name"))) continue;
                    String sql = resultSet.getString("sql");
                    for (Property property : entity.properties) {
                        if (!sql.contains("foreign key(\"" + property.column + "\")")) continue;
                        property.foreignKeyColumn = true;
                    }
                }
            }
        }, new FlowDataFeature[0]).execute();
    }
}

