/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.database.ddl.flow.property.getEntityPropertyList;

import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.entity.Entity;
import cn.schoolwow.quickdao.domain.entity.Property;
import cn.schoolwow.quickdao.module.database.parent.domain.ResultSetConsumer;
import cn.schoolwow.quickdao.module.database.parent.flow.executor.ExecuteQueryConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.domain.FlowDataFeature;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.sql.ResultSet;
import java.util.List;

public class GetEntityPropertyListByH2Flow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkInstanceData(QuickDAOConfig.class);
        final List entityList = (List)flowContext.checkData("entityList");
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u83b7\u53d6\u8868\u5b57\u6bb5\u4fe1\u606f").putTemporaryData("sql", (Object)("select table_name, column_name, type_name, character_maximum_length, is_nullable, column_default from information_schema.`columns` where table_schema = '" + quickDAOConfig.databaseContext.databaseName + "';")).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    String tableName = resultSet.getString("table_name");
                    for (Entity entity : entityList) {
                        if (!entity.tableName.equalsIgnoreCase(tableName)) continue;
                        Property property = new Property();
                        property.column = resultSet.getString("column_name");
                        property.columnType = resultSet.getString("type_name");
                        if (property.columnType.contains(" ")) {
                            property.columnType = property.columnType.substring(0, property.columnType.indexOf(" "));
                        }
                        property.notNull = "NO".equals(resultSet.getString("is_nullable"));
                        if (null != resultSet.getString("column_default")) {
                            property.defaultValue = resultSet.getString("column_default");
                        }
                        entity.properties.add(property);
                    }
                }
            }
        }, new FlowDataFeature[0]).execute();
    }

    public String name() {
        return "\u83b7\u53d6\u6570\u636e\u5e93\u8868\u5b57\u6bb5\u5217\u8868-H2\u6570\u636e\u5e93";
    }
}

