/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.database.ddl.flow.property.getEntityPropertyList;

import cn.schoolwow.quickdao.annotation.IdStrategy;
import cn.schoolwow.quickdao.domain.entity.Entity;
import cn.schoolwow.quickdao.domain.entity.Property;
import cn.schoolwow.quickdao.module.database.parent.domain.ResultSetConsumer;
import cn.schoolwow.quickdao.module.database.parent.flow.executor.ExecuteQueryConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.domain.FlowDataFeature;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.sql.ResultSet;
import java.util.List;

public class GetEntityPropertyListByPostgresFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        final List entityList = (List)flowContext.checkData("entityList");
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u83b7\u53d6\u8868\u5b57\u6bb5\u4fe1\u606f").putTemporaryData("sql", (Object)"select pg_class.relname as table_name, attname as column_name, attnum as oridinal_position, attnotnull as notnull, format_type(atttypid,atttypmod) as type, col_description(attrelid, attnum) as comment from pg_attribute join pg_class on pg_attribute.attrelid = pg_class.oid where attnum > 0 and atttypid > 0").putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    String tableName = resultSet.getString("table_name");
                    for (Entity entity : entityList) {
                        if (!entity.tableName.equalsIgnoreCase(tableName)) continue;
                        Property property = new Property();
                        property.column = resultSet.getString("column_name");
                        property.columnType = resultSet.getString("type");
                        property.notNull = "t".equals(resultSet.getString("notnull"));
                        property.comment = resultSet.getString("comment");
                        entity.properties.add(property);
                    }
                }
            }
        }, new FlowDataFeature[0]).execute();
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u83b7\u53d6\u8868\u5b57\u6bb5\u7c7b\u578b\u4fe1\u606f").putTemporaryData("sql", (Object)"select table_name,ordinal_position,column_name,column_default,is_nullable,udt_name,character_maximum_length,column_default from information_schema.columns").putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    String tableName = resultSet.getString("table_name");
                    for (Entity entity : entityList) {
                        if (!entity.tableName.equalsIgnoreCase(tableName)) continue;
                        String columnName = resultSet.getString("column_name");
                        for (Property property : entity.properties) {
                            if (!property.column.equalsIgnoreCase(columnName)) continue;
                            property.columnType = resultSet.getString("udt_name");
                            if (null == resultSet.getString("column_default")) continue;
                            property.defaultValue = resultSet.getString("column_default");
                            if (!property.defaultValue.startsWith("nextval(")) continue;
                            property.id = true;
                            property.strategy = IdStrategy.AutoIncrement;
                        }
                    }
                }
            }
        }, new FlowDataFeature[0]).execute();
    }

    public String name() {
        return "\u83b7\u53d6\u6570\u636e\u5e93\u8868\u5b57\u6bb5\u5217\u8868-Postgres\u6570\u636e\u5e93";
    }
}

