/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.database.ddl.flow.property.getEntityPropertyList;

import cn.schoolwow.quickdao.annotation.IdStrategy;
import cn.schoolwow.quickdao.domain.entity.Entity;
import cn.schoolwow.quickdao.domain.entity.Property;
import cn.schoolwow.quickdao.module.database.parent.domain.ResultSetConsumer;
import cn.schoolwow.quickdao.module.database.parent.flow.executor.ExecuteQueryConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.domain.FlowDataFeature;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.sql.ResultSet;
import java.util.List;

public class GetEntityPropertyListBySQLServerFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        final List entityList = (List)flowContext.checkData("entityList");
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u83b7\u53d6\u8868\u5b57\u6bb5\u7c7b\u578b\u4fe1\u606f").putTemporaryData("sql", (Object)"select table_name,ordinal_position,column_name,column_type,is_nullable from information_schema.columns;").putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    String tableName = resultSet.getString("table_name");
                    for (Entity entity : entityList) {
                        if (!entity.tableName.equalsIgnoreCase(tableName)) continue;
                        Property property = new Property();
                        property.column = resultSet.getString("column_name");
                        property.columnType = resultSet.getString("column_type");
                        property.notNull = "NO".equals(resultSet.getString("is_nullable"));
                        entity.properties.add(property);
                    }
                }
            }
        }, new FlowDataFeature[0]).execute();
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u83b7\u53d6\u8868\u5b57\u6bb5\u6ce8\u91ca").putTemporaryData("sql", (Object)"select b.name table_name, c.name column_name, convert(varchar(255),a.value) value from sys.extended_properties a, sysobjects b, sys.columns c where a.major_id = b.id and c.object_id = b.id and c.column_id = a.minor_id;").putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    String tableName = resultSet.getString("table_name");
                    for (Entity entity : entityList) {
                        if (!entity.tableName.equalsIgnoreCase(tableName)) continue;
                        String columnName = resultSet.getString("column_name");
                        for (Property property : entity.properties) {
                            if (!property.column.equalsIgnoreCase(columnName)) continue;
                            property.comment = resultSet.getString("value");
                        }
                    }
                }
            }
        }, new FlowDataFeature[0]).execute();
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u83b7\u53d6\u8868\u4e3b\u952e").putTemporaryData("sql", (Object)"select table_name, column_name from information_schema.key_column_usage").putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    String tableName = resultSet.getString("table_name");
                    for (Entity entity : entityList) {
                        if (!entity.tableName.equalsIgnoreCase(tableName)) continue;
                        String columnName = resultSet.getString("column_name");
                        for (Property property : entity.properties) {
                            if (!property.column.equalsIgnoreCase(columnName)) continue;
                            property.id = true;
                            property.strategy = IdStrategy.AutoIncrement;
                        }
                    }
                }
            }
        }, new FlowDataFeature[0]).execute();
    }

    public String name() {
        return "\u83b7\u53d6\u6570\u636e\u5e93\u8868\u5b57\u6bb5\u5217\u8868-SQLServer\u6570\u636e\u5e93";
    }
}

