/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.database.ddl.flow.property.getProperty;

import cn.schoolwow.quickdao.domain.entity.Property;
import cn.schoolwow.quickdao.module.database.parent.domain.ResultSetConsumer;
import cn.schoolwow.quickdao.module.database.parent.flow.executor.ExecuteQueryConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.domain.FlowDataFeature;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.sql.ResultSet;
import java.util.Arrays;

public class GetPropertyByOracleFlow
implements BusinessFlow {
    public void executeBusinessFlow(final FlowContext flowContext) throws Exception {
        String tableName = (String)flowContext.checkData("tableName");
        String columnName = (String)flowContext.checkData("columnName");
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u83b7\u53d6\u6307\u5b9a\u8868\u5b57\u6bb5\u4fe1\u606f").putTemporaryData("sql", (Object)"select column_type, nullable, data_length from user_tab_columns where table_name = ? and column_name = ?").putTemporaryData("parameters", Arrays.asList(tableName, columnName)).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                if (resultSet.next()) {
                    Property property = new Property();
                    property.column = resultSet.getString("column_name");
                    property.columnType = resultSet.getString("column_type");
                    if (property.columnType.contains(" ")) {
                        property.columnType = property.columnType.substring(0, property.columnType.indexOf(" "));
                    }
                    String dataLength = resultSet.getString("data_length");
                    if (property.columnType.toLowerCase().contains("char") && null != dataLength && !dataLength.isEmpty()) {
                        property.columnType = property.columnType + "(" + dataLength + ")";
                    }
                    property.notNull = "N".equals(resultSet.getString("nullable"));
                    flowContext.putData("property", (Object)property, new FlowDataFeature[0]);
                }
            }
        }, new FlowDataFeature[0]).execute();
        if (flowContext.containKey("property")) {
            flowContext.broken("\u5b57\u6bb5\u4e0d\u5b58\u5728");
        }
        final Property property = (Property)flowContext.checkData("property");
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u83b7\u53d6\u6307\u5b9a\u8868\u5b57\u6bb5\u6ce8\u91ca").putTemporaryData("sql", (Object)"select comments from user_col_comments where table_name = ? and column_name = ?").putTemporaryData("parameters", Arrays.asList(tableName, columnName)).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                if (resultSet.next()) {
                    property.comment = resultSet.getString("comments");
                }
            }
        }, new FlowDataFeature[0]).execute();
    }

    public String name() {
        return "\u83b7\u53d6\u6570\u636e\u5e93\u5b57\u6bb5-Oracle\u6570\u636e\u5e93";
    }
}

