/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.database.ddl.flow.table;

import cn.schoolwow.quickdao.domain.database.parent.DatabaseType;
import cn.schoolwow.quickdao.domain.entity.Entity;
import cn.schoolwow.quickdao.module.database.parent.domain.ResultSetConsumer;
import cn.schoolwow.quickdao.module.database.parent.flow.executor.ExecuteQueryConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.domain.FlowDataFeature;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class GetEntityListFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        DatabaseType databaseType = (DatabaseType)((Object)flowContext.checkData("databaseType"));
        ArrayList entityList = new ArrayList();
        flowContext.putData("entityList", entityList, new FlowDataFeature[0]);
        switch (databaseType) {
            case H2: {
                this.getByH2(flowContext);
                break;
            }
            case SQLite: {
                this.getBySQLite(flowContext);
                break;
            }
            case Mysql: 
            case MariaDB: {
                this.getByMysql(flowContext);
                break;
            }
            case Postgresql: {
                this.getByPostgres(flowContext);
                break;
            }
            case SQLServer: {
                this.getBySQLServer(flowContext);
                break;
            }
            case Oracle: {
                this.getByOracle(flowContext);
            }
        }
    }

    public String name() {
        return "\u83b7\u53d6\u6570\u636e\u5e93\u8868\u4fe1\u606f\u5217\u8868";
    }

    private void getByH2(FlowContext flowContext) {
        final List entityList = (List)flowContext.getData("entityList");
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u83b7\u53d6\u8868\u5217\u8868").putTemporaryData("sql", (Object)"show tables;").putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    Entity entity = new Entity();
                    entity.tableName = resultSet.getString(1);
                    entityList.add(entity);
                }
            }
        }, new FlowDataFeature[0]).execute();
    }

    private void getBySQLite(FlowContext flowContext) {
        final List entityList = (List)flowContext.getData("entityList");
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u83b7\u53d6\u8868\u5217\u8868").putTemporaryData("sql", (Object)"select name from sqlite_master where type='table' and name != 'sqlite_sequence';").putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    Entity entity = new Entity();
                    entity.tableName = resultSet.getString("name");
                    entityList.add(entity);
                }
            }
        }, new FlowDataFeature[0]).execute();
    }

    private void getByMysql(FlowContext flowContext) {
        final List entityList = (List)flowContext.getData("entityList");
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u83b7\u53d6\u8868\u5217\u8868").putTemporaryData("sql", (Object)"show table status;").putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    Entity entity = new Entity();
                    entity.tableName = resultSet.getString("name");
                    entity.comment = resultSet.getString("comment").replace("\"", "\\\"");
                    entityList.add(entity);
                }
            }
        }, new FlowDataFeature[0]).execute();
    }

    private void getByPostgres(FlowContext flowContext) throws SQLException {
        final List entityList = (List)flowContext.getData("entityList");
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u83b7\u53d6\u8868\u5217\u8868").putTemporaryData("sql", (Object)"select relname as name,cast(obj_description(relfilenode,'pg_class') as varchar) as comment from pg_class c where  relkind = 'r' and relname not like 'pg_%' and relname not like 'sql_%' order by relname;").putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    Entity entity = new Entity();
                    entity.tableName = resultSet.getString("name");
                    entity.comment = resultSet.getString("comment");
                    entityList.add(entity);
                }
            }
        }, new FlowDataFeature[0]).execute();
    }

    private void getBySQLServer(FlowContext flowContext) {
        final List entityList = (List)flowContext.getData("entityList");
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u83b7\u53d6\u8868\u5217\u8868").putTemporaryData("sql", (Object)"select name from sysobjects where xtype='u' order by name;").putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    Entity entity = new Entity();
                    entity.tableName = resultSet.getString("name");
                    entityList.add(entity);
                }
            }
        }, new FlowDataFeature[0]).execute();
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u83b7\u53d6\u8868\u6ce8\u91ca").putTemporaryData("sql", (Object)"select so.name table_name, isnull(convert(varchar(255),value),'') comment from sys.extended_properties ex_p left join sys.sysobjects so on ex_p.major_id = so.id where ex_p.minor_id=0;").putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                block0: while (resultSet.next()) {
                    String tableName = resultSet.getString("table_name");
                    for (Entity entity : entityList) {
                        if (!entity.tableName.equalsIgnoreCase(tableName)) continue;
                        entity.comment = resultSet.getString("comment");
                        continue block0;
                    }
                }
            }
        }, new FlowDataFeature[0]).execute();
    }

    private void getByOracle(FlowContext flowContext) {
        final List entityList = (List)flowContext.getData("entityList");
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u83b7\u53d6\u8868\u5217\u8868").putTemporaryData("sql", (Object)"select user_tables.table_name, user_tab_comments.comments from user_tables left join user_tab_comments on user_tables.table_name = user_tab_comments.table_name").putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    Entity entity = new Entity();
                    entity.tableName = resultSet.getString("table_name");
                    entity.comment = resultSet.getString("comments");
                    entityList.add(entity);
                }
            }
        }, new FlowDataFeature[0]).execute();
    }
}

