/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.database.ddl.service.column.has;

import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.database.parent.DatabaseType;
import cn.schoolwow.quickdao.domain.entity.Entity;
import cn.schoolwow.quickdao.module.database.ddl.flow.has.common.SetHasResultSetFlow;
import cn.schoolwow.quickdao.module.database.parent.flow.executor.ExecuteQueryConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.util.Arrays;

public class HasTableColumnFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkInstanceData(QuickDAOConfig.class);
        DatabaseType databaseType = (DatabaseType)((Object)flowContext.checkData("databaseType"));
        String tableName = (String)flowContext.getData("tableName");
        String columnName = (String)flowContext.checkData("columnName");
        if (null == tableName) {
            Class clazz = (Class)flowContext.checkData("clazz");
            Entity entity = quickDAOConfig.getEntityByClassName(clazz.getName());
            tableName = entity.tableName;
            columnName = entity.getColumnNameByFieldName(columnName);
        }
        flowContext.putTemporaryData("name", (Object)"\u5224\u65ad\u8868\u6307\u5b9a\u5217\u662f\u5426\u5b58\u5728");
        switch (databaseType) {
            case H2: {
                tableName = tableName.toUpperCase();
                columnName = columnName.toUpperCase();
                flowContext.putTemporaryData("sql", (Object)"select table_name, column_name from information_schema.`columns` where table_schema = 'PUBLIC' and table_name = ? and column_name = ?;");
                break;
            }
            case SQLite: {
                columnName = "%" + columnName + "%";
                flowContext.putTemporaryData("sql", (Object)"select name from sqlite_master where name = ? and sql like ?");
                break;
            }
            case Mysql: 
            case MariaDB: {
                flowContext.putTemporaryData("sql", (Object)("select table_name, column_name from information_schema.`columns` where table_schema = '" + quickDAOConfig.databaseContext.databaseName + "' and table_name = ? and column_name = ?;"));
                break;
            }
            case Postgresql: {
                flowContext.putTemporaryData("sql", (Object)"select pg_class.relname as table_name, attname as column_name from pg_attribute join pg_class on pg_attribute.attrelid = pg_class.oid where attnum > 0 and atttypid > 0 and pg_class.relname = ? and attname = ?;");
                break;
            }
            case SQLServer: {
                flowContext.putTemporaryData("sql", (Object)"select table_name, column_name from information_schema.columns where table_name = ? and column_name = ?;");
                break;
            }
            case Oracle: {
                flowContext.putTemporaryData("sql", (Object)"select table_name, column_name from user_tab_columns where table_name = ? and column_name = ?");
            }
        }
        flowContext.putTemporaryData("parameters", Arrays.asList(tableName, columnName));
        flowContext.executeFlowList(new BusinessFlow[]{new SetHasResultSetFlow(), new ExecuteQueryConnectionFlow()});
    }

    public String name() {
        return "\u8868\u6307\u5b9a\u5217\u662f\u5426\u5b58\u5728";
    }
}

