/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.database.ddl.service.foreignKey;

import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.database.parent.DatabaseType;
import cn.schoolwow.quickdao.domain.entity.Entity;
import cn.schoolwow.quickdao.module.database.parent.flow.executor.ExecuteUpdateConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class EnableForeignConstraintCheckFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        boolean enable = (Boolean)flowContext.checkData("enable");
        if (enable) {
            this.enableForeignKey(flowContext);
        } else {
            this.disableForeignKey(flowContext);
        }
    }

    public String name() {
        return "\u5f00\u542f/\u5173\u95ed\u5916\u952e\u7ea6\u675f\u68c0\u67e5";
    }

    private void enableForeignKey(FlowContext flowContext) {
        DatabaseType databaseType = (DatabaseType)((Object)flowContext.checkData("databaseType"));
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkInstanceData(QuickDAOConfig.class);
        switch (databaseType) {
            case SQLite: {
                flowContext.putTemporaryData("sql", (Object)"PRAGMA foreign_keys = true;");
                break;
            }
            case Mysql: 
            case MariaDB: {
                flowContext.putTemporaryData("sql", (Object)"set foreign_key_checks = 1;");
                break;
            }
            case Postgresql: {
                String tableName = (String)flowContext.getData("tableName");
                if (null == tableName) {
                    StringBuilder sqlBuilder = new StringBuilder();
                    for (Entity entity : quickDAOConfig.databaseContext.entityMap.values()) {
                        if (!entity.foreignKeyProperties.isEmpty()) {
                            sqlBuilder.append("alter table \"" + entity.tableName + "\" enable trigger all;");
                        }
                        flowContext.putTemporaryData("sql", (Object)sqlBuilder.toString());
                    }
                    break;
                }
                flowContext.putTemporaryData("sql", (Object)("alter table \"" + tableName + "\" enable trigger all;"));
                break;
            }
            default: {
                flowContext.broken("\u5f53\u524d\u6570\u636e\u5e93\u4e0d\u652f\u6301\u5f00\u542f/\u5173\u95ed\u5916\u952e\u7ea6\u675f!");
            }
        }
        flowContext.startFlow((BusinessFlow)new ExecuteUpdateConnectionFlow()).putTemporaryData("name", (Object)"\u542f\u7528\u5916\u952e\u7ea6\u675f\u68c0\u67e5").execute();
    }

    private void disableForeignKey(FlowContext flowContext) {
        DatabaseType databaseType = (DatabaseType)((Object)flowContext.checkData("databaseType"));
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkInstanceData(QuickDAOConfig.class);
        switch (databaseType) {
            case SQLite: {
                flowContext.putTemporaryData("sql", (Object)"PRAGMA foreign_keys = false;");
                break;
            }
            case Mysql: 
            case MariaDB: {
                flowContext.putTemporaryData("sql", (Object)"set foreign_key_checks = 0;");
                break;
            }
            case Postgresql: {
                String tableName = (String)flowContext.getData("tableName");
                if (null == tableName) {
                    StringBuilder sqlBuilder = new StringBuilder();
                    for (Entity entity : quickDAOConfig.databaseContext.entityMap.values()) {
                        if (!entity.foreignKeyProperties.isEmpty()) {
                            sqlBuilder.append("alter table \"" + entity.tableName + "\" disable trigger all;");
                        }
                        flowContext.putTemporaryData("sql", (Object)sqlBuilder.toString());
                    }
                    break;
                }
                flowContext.putTemporaryData("sql", (Object)("alter table \"" + tableName + "\" disable trigger all;"));
                break;
            }
            default: {
                flowContext.broken("\u5f53\u524d\u6570\u636e\u5e93\u4e0d\u652f\u6301\u5f00\u542f/\u5173\u95ed\u5916\u952e\u7ea6\u675f!");
            }
        }
        flowContext.startFlow((BusinessFlow)new ExecuteUpdateConnectionFlow()).putTemporaryData("name", (Object)"\u7981\u7528\u5916\u952e\u7ea6\u675f\u68c0\u67e5").execute();
    }
}

