/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.database.ddl.service.index.getEntityIndexFlow;

import cn.schoolwow.quickdao.annotation.IndexType;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.database.ddl.IndexField;
import cn.schoolwow.quickdao.domain.entity.Entity;
import cn.schoolwow.quickdao.module.database.parent.domain.ResultSetConsumer;
import cn.schoolwow.quickdao.module.database.parent.flow.executor.ExecuteQueryConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.domain.FlowDataFeature;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.sql.ResultSet;
import java.util.Arrays;

public class GetEntityIndexByMySQLFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkInstanceData(QuickDAOConfig.class);
        final Entity entity = (Entity)flowContext.checkData("entity");
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("sql", (Object)("select table_name, index_name, non_unique, column_name, index_type, index_comment from information_schema.`statistics` where table_schema = '" + quickDAOConfig.databaseContext.databaseName + "' and table_name = ?;")).putTemporaryData("parameters", Arrays.asList(entity.tableName)).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    String indexName = resultSet.getString("index_name");
                    if ("PRIMARY".equalsIgnoreCase(indexName)) continue;
                    IndexField existIndexField = null;
                    for (IndexField indexField : entity.indexFieldList) {
                        if (!indexField.indexName.equals(indexName)) continue;
                        existIndexField = indexField;
                        break;
                    }
                    if (null == existIndexField) {
                        IndexField indexField = new IndexField();
                        indexField.tableName = resultSet.getString("table_name");
                        IndexType indexType = indexField.indexType = resultSet.getInt("non_unique") == 0 ? IndexType.UNIQUE : IndexType.NORMAL;
                        if ("FULLTEXT".equals(resultSet.getString("index_type"))) {
                            indexField.indexType = IndexType.FULLTEXT;
                        }
                        indexField.indexName = resultSet.getString("index_name");
                        indexField.columns.add(resultSet.getString("column_name"));
                        indexField.using = resultSet.getString("index_type");
                        indexField.comment = resultSet.getString("index_comment");
                        entity.indexFieldList.add(indexField);
                        continue;
                    }
                    existIndexField.columns.add(resultSet.getString("column_name"));
                }
            }
        }, new FlowDataFeature[0]).execute();
    }

    public String name() {
        return "\u83b7\u53d6\u6570\u636e\u5e93\u7d22\u5f15\u4fe1\u606f-MySQL";
    }
}

