/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.database.ddl.service.index.getEntityIndexFlow;

import cn.schoolwow.quickdao.annotation.IndexType;
import cn.schoolwow.quickdao.domain.database.ddl.IndexField;
import cn.schoolwow.quickdao.domain.entity.Entity;
import cn.schoolwow.quickdao.module.database.parent.domain.ResultSetConsumer;
import cn.schoolwow.quickdao.module.database.parent.flow.executor.ExecuteQueryConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.domain.FlowDataFeature;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.sql.ResultSet;
import java.util.Arrays;

public class GetEntityIndexByOracleFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        final Entity entity = (Entity)flowContext.checkData("entity");
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("sql", (Object)"select table_name, index_name,uniqueness from user_indexes where table_name = ?").putTemporaryData("parameters", Arrays.asList(entity.tableName)).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    IndexField indexField = new IndexField();
                    indexField.tableName = resultSet.getString("table_name");
                    indexField.indexType = "UNIQUE".equalsIgnoreCase(resultSet.getString("uniqueness")) ? IndexType.UNIQUE : IndexType.NORMAL;
                    indexField.indexName = resultSet.getString("index_name");
                    entity.indexFieldList.add(indexField);
                }
            }
        }, new FlowDataFeature[0]).execute();
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u83b7\u53d6\u7d22\u5f15\u5b57\u6bb5\u4fe1\u606f").putTemporaryData("sql", (Object)"select table_name,index_name,column_name from user_ind_columns where table_name = ?").putTemporaryData("parameters", Arrays.asList(entity.tableName)).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    String indexName = resultSet.getString("index_name");
                    String columnName = resultSet.getString("column_name");
                    for (IndexField indexField : entity.indexFieldList) {
                        if (!indexField.indexName.equalsIgnoreCase(indexName)) continue;
                        indexField.columns.add(columnName);
                    }
                }
            }
        }, new FlowDataFeature[0]).execute();
    }

    public String name() {
        return "\u83b7\u53d6\u6570\u636e\u5e93\u7d22\u5f15\u4fe1\u606f-Oracle";
    }
}

