/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.database.ddl.service.index.getEntityIndexFlow;

import cn.schoolwow.quickdao.annotation.IndexType;
import cn.schoolwow.quickdao.domain.database.ddl.IndexField;
import cn.schoolwow.quickdao.domain.entity.Entity;
import cn.schoolwow.quickdao.module.database.parent.domain.ResultSetConsumer;
import cn.schoolwow.quickdao.module.database.parent.flow.executor.ExecuteQueryConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.domain.FlowDataFeature;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.sql.ResultSet;
import java.util.Arrays;

public class GetEntityIndexBySQLServerFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        final Entity entity = (Entity)flowContext.checkData("entity");
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("sql", (Object)"select i.is_unique,i.name,col.name col_name from sys.indexes i left join sys.index_columns ic on ic.object_id = i.object_id and ic.index_id = i.index_id left join (select * from sys.all_columns where object_id = object_id(?, N'U' )) col on ic.column_id = col.column_id where i.object_id = object_id(?, N'U' ) and i.index_id > 0;").putTemporaryData("parameters", Arrays.asList(entity.tableName, entity.tableName)).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    IndexField indexField = new IndexField();
                    indexField.indexType = resultSet.getBoolean("is_unique") ? IndexType.UNIQUE : IndexType.NORMAL;
                    indexField.tableName = entity.tableName;
                    indexField.indexName = resultSet.getString("name");
                    IndexField existIndexField = null;
                    for (IndexField entityIndexField : entity.indexFieldList) {
                        if (!entityIndexField.indexName.equalsIgnoreCase(indexField.indexName)) continue;
                        existIndexField = entityIndexField;
                        break;
                    }
                    if (null != existIndexField) {
                        existIndexField.columns.add(resultSet.getNString("col_name"));
                        continue;
                    }
                    indexField.columns.add(resultSet.getNString("col_name"));
                    entity.indexFieldList.add(indexField);
                }
            }
        }, new FlowDataFeature[0]).execute();
    }

    public String name() {
        return "\u83b7\u53d6\u6570\u636e\u5e93\u7d22\u5f15\u4fe1\u606f-SQLServer";
    }
}

