/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.database.ddl.service.index.getSingleEntityIndexFlow;

import cn.schoolwow.quickdao.annotation.IndexType;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.database.ddl.IndexField;
import cn.schoolwow.quickdao.module.database.parent.domain.ResultSetConsumer;
import cn.schoolwow.quickdao.module.database.parent.flow.executor.ExecuteQueryConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.domain.FlowDataFeature;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.sql.ResultSet;
import java.util.Arrays;

public class GetSingleEntityIndexByMySQLFlow
implements BusinessFlow {
    public void executeBusinessFlow(final FlowContext flowContext) throws Exception {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkInstanceData(QuickDAOConfig.class);
        String tableName = (String)flowContext.checkData("tableName");
        String indexName = (String)flowContext.checkData("indexName");
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("sql", (Object)("select table_name, index_name, non_unique, column_name, index_type, index_comment from information_schema.`statistics` where table_schema = '" + quickDAOConfig.databaseContext.databaseName + "' and table_name = ? and index_name = ?;")).putTemporaryData("parameters", Arrays.asList(tableName, indexName)).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                IndexField indexField = null;
                while (resultSet.next()) {
                    if (null == indexField) {
                        indexField = new IndexField();
                        IndexType indexType = indexField.indexType = resultSet.getInt("non_unique") == 0 ? IndexType.UNIQUE : IndexType.NORMAL;
                        if ("FULLTEXT".equals(resultSet.getString("index_type"))) {
                            indexField.indexType = IndexType.FULLTEXT;
                        }
                        indexField.indexName = resultSet.getString("index_name");
                        indexField.columns.add(resultSet.getString("column_name"));
                        indexField.using = resultSet.getString("index_type");
                        indexField.comment = resultSet.getString("index_comment");
                        continue;
                    }
                    indexField.columns.add(resultSet.getString("column_name"));
                }
                flowContext.putData("indexField", (Object)indexField, new FlowDataFeature[0]);
            }
        }, new FlowDataFeature[0]).execute();
    }

    public String name() {
        return "\u83b7\u53d6\u6570\u636e\u5e93\u5355\u4e2a\u8868\u7684\u7d22\u5f15\u4fe1\u606f-MySQL";
    }
}

