/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.database.ddl.service.index.getSingleEntityIndexFlow;

import cn.schoolwow.quickdao.annotation.IndexType;
import cn.schoolwow.quickdao.domain.database.ddl.IndexField;
import cn.schoolwow.quickdao.module.database.parent.domain.ResultSetConsumer;
import cn.schoolwow.quickdao.module.database.parent.flow.executor.ExecuteQueryConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.domain.FlowDataFeature;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.sql.ResultSet;
import java.util.Arrays;

public class GetSingleEntityIndexByOracleFlow
implements BusinessFlow {
    public void executeBusinessFlow(final FlowContext flowContext) throws Exception {
        String tableName = (String)flowContext.checkData("tableName");
        String indexName = (String)flowContext.checkData("indexName");
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("sql", (Object)"select table_name, index_name,uniqueness from user_indexes where table_name = ? and index_name = ?").putTemporaryData("parameters", Arrays.asList(tableName, indexName)).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                if (resultSet.next()) {
                    IndexField indexField = new IndexField();
                    indexField.tableName = resultSet.getString("table_name");
                    indexField.indexType = "UNIQUE".equalsIgnoreCase(resultSet.getString("uniqueness")) ? IndexType.UNIQUE : IndexType.NORMAL;
                    indexField.indexName = resultSet.getString("index_name");
                    flowContext.putData("indexField", (Object)indexField, new FlowDataFeature[0]);
                }
            }
        }, new FlowDataFeature[0]).execute();
        final IndexField indexField = (IndexField)flowContext.getData("indexField");
        if (null == indexField) {
            return;
        }
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u83b7\u53d6\u7d22\u5f15\u5b57\u6bb5\u4fe1\u606f").putTemporaryData("sql", (Object)"select table_name,index_name,column_name from user_ind_columns where table_name = ? and index_name = ?").putTemporaryData("parameters", Arrays.asList(tableName, indexName)).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                while (resultSet.next()) {
                    String columnName = resultSet.getString("column_name");
                    indexField.columns.add(columnName);
                }
            }
        }, new FlowDataFeature[0]).execute();
    }

    public String name() {
        return "\u83b7\u53d6\u6570\u636e\u5e93\u5355\u4e2a\u8868\u7684\u7d22\u5f15\u4fe1\u606f-Oracle";
    }
}

