/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.database.ddl.service.index.getSingleEntityIndexFlow;

import cn.schoolwow.quickdao.annotation.IndexType;
import cn.schoolwow.quickdao.domain.database.ddl.IndexField;
import cn.schoolwow.quickdao.module.database.parent.domain.ResultSetConsumer;
import cn.schoolwow.quickdao.module.database.parent.flow.executor.ExecuteQueryConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.domain.FlowDataFeature;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.sql.ResultSet;
import java.util.Arrays;

public class GetSingleEntityIndexByPostgresFlow
implements BusinessFlow {
    public void executeBusinessFlow(final FlowContext flowContext) throws Exception {
        String tableName = (String)flowContext.checkData("tableName");
        String indexName = (String)flowContext.checkData("indexName");
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("sql", (Object)"select tablename,indexname,indexdef from pg_indexes where tablename = ? and indexname = ?;").putTemporaryData("parameters", Arrays.asList(tableName, indexName)).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                if (resultSet.next()) {
                    IndexField indexField = new IndexField();
                    indexField.tableName = resultSet.getString("tablename");
                    indexField.indexName = resultSet.getString("indexname");
                    String def = resultSet.getString("indexdef");
                    indexField.indexType = def.contains("UNIQUE INDEX") ? IndexType.UNIQUE : IndexType.NORMAL;
                    indexField.using = def.substring(def.indexOf("USING") + "USING".length(), def.indexOf("(")).replace("\"", "").trim();
                    String[] columns = def.substring(def.indexOf("(") + 1, def.indexOf(")")).split(",");
                    for (int i = 0; i < columns.length; ++i) {
                        indexField.columns.add(columns[i].trim());
                    }
                    flowContext.putData("indexField", (Object)indexField, new FlowDataFeature[0]);
                }
            }
        }, new FlowDataFeature[0]).execute();
    }

    public String name() {
        return "\u83b7\u53d6\u6570\u636e\u5e93\u5355\u4e2a\u8868\u7684\u7d22\u5f15\u4fe1\u606f-Postgres";
    }
}

