/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.database.ddl.service.index.getSingleEntityIndexFlow;

import cn.schoolwow.quickdao.annotation.IndexType;
import cn.schoolwow.quickdao.domain.database.ddl.IndexField;
import cn.schoolwow.quickdao.module.database.parent.domain.ResultSetConsumer;
import cn.schoolwow.quickdao.module.database.parent.flow.executor.ExecuteQueryConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.domain.FlowDataFeature;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;

public class GetSingleEntityIndexBySQLiteFlow
implements BusinessFlow {
    public void executeBusinessFlow(final FlowContext flowContext) throws Exception {
        String tableName = (String)flowContext.checkData("tableName");
        final String indexName = (String)flowContext.checkData("indexName");
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("sql", (Object)"select tbl_name, sql from sqlite_master where type='index' and tbl_name = ? and sql is not null;").putTemporaryData("parameters", Arrays.asList(tableName)).putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                ArrayList<String> warningSQLList = new ArrayList<String>();
                while (resultSet.next()) {
                    String sql = resultSet.getString("sql");
                    if (!sql.contains("\"") && !sql.contains("`")) {
                        warningSQLList.add(sql);
                        continue;
                    }
                    String[] tokens = sql.split("[\"|`]");
                    IndexField indexField = new IndexField();
                    indexField.indexType = tokens[0].contains("UNIQUE") ? IndexType.UNIQUE : IndexType.NORMAL;
                    indexField.indexName = tokens[1];
                    indexField.tableName = tokens[3];
                    for (int i = 5; i < tokens.length - 1; ++i) {
                        indexField.columns.add(tokens[i]);
                    }
                    if (!indexField.indexName.equalsIgnoreCase(indexName)) continue;
                    flowContext.putData("indexField", (Object)indexField, new FlowDataFeature[0]);
                    break;
                }
                if (!warningSQLList.isEmpty()) {
                    flowContext.putTemporaryData("warningSQLList", warningSQLList);
                    flowContext.remark("\u5b58\u5728\u5f02\u5e38\u7d22\u5f15!\u7d22\u5f15\u4e0d\u5305\u542b\"\u4e5f\u4e0d\u5305\u542b`");
                }
            }
        }, new FlowDataFeature[0]).execute();
    }

    public String name() {
        return "\u83b7\u53d6\u6570\u636e\u5e93\u5355\u4e2a\u8868\u7684\u7d22\u5f15\u4fe1\u606f-SQLite";
    }
}

