/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.database.ddl.service.table.action;

import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.database.parent.DatabaseType;
import cn.schoolwow.quickdao.domain.provider.DatabaseProvider;
import cn.schoolwow.quickdao.module.database.parent.flow.executor.ExecuteUpdateConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class BackupTableFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkInstanceData(QuickDAOConfig.class);
        DatabaseType databaseType = (DatabaseType)((Object)flowContext.checkData("databaseType"));
        String tableName = (String)flowContext.checkData("tableName");
        String backupTableName = (String)flowContext.checkData("backupTableName");
        DatabaseProvider databaseProvider = quickDAOConfig.databaseContext.databaseProvider;
        switch (databaseType) {
            case SQLite: {
                flowContext.putTemporaryData("sql", (Object)("create table " + databaseProvider.escape(backupTableName) + " as select * from " + databaseProvider.escape(tableName) + ";"));
                break;
            }
            case Mysql: 
            case MariaDB: {
                flowContext.putTemporaryData("sql", (Object)("create table " + databaseProvider.escape(backupTableName) + " as select * from " + databaseProvider.escape(tableName) + ";"));
                break;
            }
            case Postgresql: {
                flowContext.putTemporaryData("sql", (Object)("select * into " + databaseProvider.escape(backupTableName) + " from " + databaseProvider.escape(tableName) + ";"));
                break;
            }
            default: {
                throw new UnsupportedOperationException("\u5f53\u524d\u4e0d\u652f\u6301" + databaseType.name() + "\u6570\u636e\u5e93\u5907\u4efd\u8868\u529f\u80fd");
            }
        }
        flowContext.startFlow((BusinessFlow)new ExecuteUpdateConnectionFlow()).putTemporaryData("name", (Object)"\u5907\u4efd\u8868").execute();
    }

    public String name() {
        return "\u5907\u4efd\u8868";
    }
}

