/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.database.dql.condition.kit;

import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.database.dql.condition.Condition;
import cn.schoolwow.quickdao.domain.database.dql.condition.LambdaCondition;
import cn.schoolwow.quickdao.domain.database.dql.condition.QueryColumnTypeMapping;
import cn.schoolwow.quickdao.domain.database.dql.response.PageVo;
import cn.schoolwow.quickdao.domain.database.dql.response.Response;
import cn.schoolwow.quickdao.domain.database.dql.subCondition.SubCondition;
import cn.schoolwow.quickdao.domain.entity.Entity;
import cn.schoolwow.quickdao.domain.entity.Property;
import cn.schoolwow.quickdao.domain.provider.DatabaseProvider;
import cn.schoolwow.quickdao.module.database.dql.condition.domain.QueryOption;
import cn.schoolwow.quickdao.module.database.dql.condition.domain.SQLFragmentEntry;
import cn.schoolwow.quickdao.module.database.dql.condition.flow.get.GetFromConditionStatement;
import cn.schoolwow.quickdao.module.database.dql.condition.kit.LambdaConditionInvocationHandler;
import cn.schoolwow.quickdao.module.database.dql.condition.service.CloneConditionFlow;
import cn.schoolwow.quickdao.module.database.dql.condition.service.ExecuteConditionCompositeBusiness;
import cn.schoolwow.quickdao.module.database.dql.parent.domain.QueryContext;
import cn.schoolwow.quickdao.module.database.dql.response.kit.ResponseImpl;
import cn.schoolwow.quickdao.module.database.dql.subCondition.domain.SubQueryOption;
import cn.schoolwow.quickdao.module.database.dql.subCondition.kit.SubConditionImpl;
import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.domain.FlowDataFeature;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickflow.flow.CompositeBusinessFlow;
import java.io.Serializable;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class ConditionImpl<T>
implements Condition<T>,
Serializable,
Cloneable {
    private boolean hasExecute;
    public QueryOption queryOption = new QueryOption();

    public ConditionImpl(Entity entity, QuickFlow quickFlow, QuickDAOConfig quickDAOConfig) {
        this.queryOption.queryTableOption.entity = entity;
        this.queryOption.quickFlow = quickFlow;
        this.queryOption.quickDAOConfig = quickDAOConfig;
    }

    public ConditionImpl(Condition fromCondition, QuickFlow quickFlow, QuickDAOConfig quickDAOConfig) {
        this.queryOption.queryTableOption.fromCondition = fromCondition;
        this.queryOption.quickFlow = quickFlow;
        this.queryOption.quickDAOConfig = quickDAOConfig;
    }

    private ConditionImpl(QueryOption queryOption) {
        this.queryOption = queryOption;
    }

    @Override
    public Condition<T> tableAliasName(String tableAliasName) {
        this.queryOption.queryTableOption.tableAliasName = tableAliasName;
        return this;
    }

    @Override
    public Condition<T> distinct() {
        this.queryOption.queryColumnOption.distinct = "distinct ";
        return this;
    }

    @Override
    public Condition<T> addNullQuery(String field) {
        this.queryOption.queryFragmentOption.whereList.add(new SQLFragmentEntry("and", field, "{} is null"));
        return this;
    }

    @Override
    public Condition<T> addNotNullQuery(String field) {
        this.queryOption.queryFragmentOption.whereList.add(new SQLFragmentEntry("and", field, "{} is not null"));
        return this;
    }

    @Override
    public Condition<T> addEmptyQuery(String field) {
        this.queryOption.queryFragmentOption.whereList.add(new SQLFragmentEntry("and", field, "{} is not null and {} = ''"));
        return this;
    }

    @Override
    public Condition<T> addNotEmptyQuery(String field) {
        this.queryOption.queryFragmentOption.whereList.add(new SQLFragmentEntry("and", field, "{} is not null and {} != ''"));
        return this;
    }

    @Override
    public Condition<T> addInQuery(String field, String inQuery) {
        if (null == inQuery || inQuery.isEmpty()) {
            this.queryOption.queryFragmentOption.whereList.add(new SQLFragmentEntry("and", field, "1 = 2"));
            return this;
        }
        this.queryOption.queryFragmentOption.whereList.add(new SQLFragmentEntry("and", field, "{} in (" + inQuery + ")"));
        return this;
    }

    @Override
    public Condition<T> addInQuery(String field, Object ... values) {
        this.addInQuery(field, values, "in");
        return this;
    }

    @Override
    public Condition<T> addInQuery(String field, Collection values) {
        return this.addInQuery(field, values.toArray(new Object[0]));
    }

    @Override
    public Condition<T> addNotInQuery(String field, String inQuery) {
        if (null == inQuery || inQuery.isEmpty()) {
            this.queryOption.queryFragmentOption.whereList.add(new SQLFragmentEntry("and", field, "1 = 2"));
            return this;
        }
        this.queryOption.queryFragmentOption.whereList.add(new SQLFragmentEntry("and", field, "{} not in (" + inQuery + ")"));
        return this;
    }

    @Override
    public Condition<T> addNotInQuery(String field, Object ... values) {
        this.addInQuery(field, values, "not in");
        return this;
    }

    @Override
    public Condition<T> addNotInQuery(String field, Collection values) {
        return this.addNotInQuery(field, values.toArray(new Object[0]));
    }

    @Override
    public Condition<T> addBetweenQuery(String field, Object start, Object end) {
        this.queryOption.queryFragmentOption.whereList.add(new SQLFragmentEntry("and", field, "{} between ? and ?"));
        this.queryOption.queryFragmentOption.whereParameterList.add(start);
        this.queryOption.queryFragmentOption.whereParameterList.add(end);
        return this;
    }

    @Override
    public Condition<T> addLikeQuery(String field, Object value) {
        if (value == null || value.toString().equals("")) {
            return this;
        }
        switch (this.queryOption.quickDAOConfig.databaseContext.databaseProvider.getDatabaseType()) {
            case SQLServer: {
                this.queryOption.queryFragmentOption.whereList.add(new SQLFragmentEntry("and", field, "charindex(?,{}) > 0"));
                this.queryOption.queryFragmentOption.whereParameterList.add(value.toString());
                break;
            }
            default: {
                this.queryOption.queryFragmentOption.whereList.add(new SQLFragmentEntry("and", field, "{} like ?"));
                this.queryOption.queryFragmentOption.whereParameterList.add(value);
            }
        }
        return this;
    }

    @Override
    public Condition<T> addNotLikeQuery(String field, Object value) {
        if (value == null || value.toString().equals("")) {
            return this;
        }
        this.queryOption.queryFragmentOption.whereList.add(new SQLFragmentEntry("and", field, "{} not like ?"));
        this.queryOption.queryFragmentOption.whereParameterList.add(value);
        return this;
    }

    @Override
    public Condition<T> addQuery(String field, Object value) {
        this.addQuery(field, "=", value);
        return this;
    }

    @Override
    public Condition<T> addQuery(String field, String operator, Object value) {
        if (null == value) {
            this.addNullQuery(field);
        } else if (value.toString().isEmpty()) {
            this.addEmptyQuery(field);
        } else {
            Property property;
            Entity entity = this.queryOption.queryTableOption.entity;
            Property property2 = property = null == entity ? null : entity.getPropertyByFieldNameOrColumnName(field);
            if (null == property) {
                this.queryOption.queryFragmentOption.whereList.add(new SQLFragmentEntry("and", field, "{} " + operator + "?"));
            } else {
                this.queryOption.queryFragmentOption.whereList.add(new SQLFragmentEntry("and", field, "{} " + operator + " " + (null == property.function ? "?" : property.function)));
            }
            this.queryOption.queryFragmentOption.whereParameterList.add(value);
        }
        return this;
    }

    @Override
    public Condition<T> addIntervalQuery(String field, String value) {
        if (!value.contains(",")) {
            return this;
        }
        Long priceStart = Long.parseLong(value.substring(1, value.indexOf(",")));
        Long priceEnd = Long.parseLong(value.substring(value.indexOf(",") + 1, value.length() - 1));
        if (priceEnd < priceStart) {
            throw new IllegalArgumentException("\u5f00\u95ed\u533a\u95f4\u4e0d\u5408\u6cd5!\u8bf7\u68c0\u67e5!\u5f00\u95ed\u533a\u95f4\u503c:" + value);
        }
        switch (value.charAt(0)) {
            case '(': {
                this.addQuery(field, ">", priceStart);
                break;
            }
            case '[': {
                this.addQuery(field, ">=", priceStart);
                break;
            }
            default: {
                throw new IllegalArgumentException("\u5f00\u95ed\u533a\u95f4\u5f00\u59cb\u503c\u5fc5\u987b\u4e3a'('\u6216\u8005'['!\u5f53\u524d\u503c:" + value.charAt(0));
            }
        }
        switch (value.charAt(value.length() - 1)) {
            case ')': {
                this.addQuery(field, "<", priceEnd);
                break;
            }
            case ']': {
                this.addQuery(field, "<=", priceEnd);
                break;
            }
            default: {
                throw new IllegalArgumentException("\u5f00\u95ed\u533a\u95f4\u7ed3\u675f\u503c\u5fc5\u987b\u4e3a')'\u6216\u8005']'!\u5f53\u524d\u503c:" + value.charAt(value.length() - 1));
            }
        }
        return this;
    }

    @Override
    public Condition<T> addCompositeQuery(String field, String value) {
        if (value.startsWith("null:")) {
            this.addNullQuery(field);
        } else if (value.startsWith("not null:")) {
            this.addNotNullQuery(field);
        } else if (value.startsWith("empty:")) {
            this.addEmptyQuery(field);
        } else if (value.startsWith("not empty:")) {
            this.addNotEmptyQuery(field);
        } else if (value.startsWith("like:")) {
            this.addLikeQuery(field, value.substring(5));
        } else if (value.startsWith("not like:")) {
            this.addNotLikeQuery(field, value.substring(9));
        } else if (value.startsWith("in:")) {
            this.addInQuery(field, Arrays.asList(value.substring(3).split(",", -1)));
        } else if (value.startsWith("not in:")) {
            this.addNotInQuery(field, value.substring(7));
        } else if (value.startsWith("interval:")) {
            this.addIntervalQuery(field, value.substring(9));
        } else if (value.startsWith("between:")) {
            String start = value.substring(8, value.indexOf(","));
            String end = value.substring(value.indexOf(",") + 1);
            this.addBetweenQuery(field, start, end);
        } else if (value.startsWith("gt:")) {
            this.addQuery(field, ">", value.substring(3));
        } else if (value.startsWith("gte:")) {
            this.addQuery(field, ">=", value.substring(4));
        } else if (value.startsWith("lt:")) {
            this.addQuery(field, "<", value.substring(3));
        } else if (value.startsWith("lte:")) {
            this.addQuery(field, "<=", value.substring(4));
        } else {
            this.addQuery(field, value);
        }
        return this;
    }

    @Override
    public Condition<T> addRawQuery(String query, Object ... parameterList) {
        this.queryOption.queryFragmentOption.whereList.add(new SQLFragmentEntry("and", null, query));
        if (null != parameterList && parameterList.length > 0) {
            this.queryOption.queryFragmentOption.whereParameterList.addAll(Arrays.asList(parameterList));
        }
        return this;
    }

    @Override
    public Condition<T> addSubQuery(String field, Condition subQuery) {
        return this.addSubQuery(field, "=", subQuery);
    }

    @Override
    public Condition<T> addSubQuery(String field, String operator, Condition subCondition) {
        this.queryOption.setConditionTableAliasName(subCondition);
        FlowContext flowContext = this.queryOption.quickFlow.startFlow((BusinessFlow)new GetFromConditionStatement()).putTemporaryData("fromCondition", (Object)subCondition).execute();
        String fromConditionStatement = (String)flowContext.checkData("fromConditionStatement");
        List fromConditionParameters = (List)flowContext.getData("fromConditionParameters");
        this.queryOption.queryFragmentOption.whereList.add(new SQLFragmentEntry("and", field, " {} " + operator + " (" + fromConditionStatement + ")"));
        this.queryOption.queryFragmentOption.whereParameterList.addAll(fromConditionParameters);
        return this;
    }

    @Override
    public Condition<T> addExistSubQuery(Condition subQuery) {
        this.addExistSubQuery(subQuery, "exists");
        return this;
    }

    @Override
    public Condition<T> addNotExistSubQuery(Condition subQuery) {
        this.addExistSubQuery(subQuery, "not exists");
        return this;
    }

    @Override
    public Condition<T> addColumn(String ... fields) {
        this.queryOption.queryColumnOption.columnList.addAll(Arrays.asList(fields));
        return this;
    }

    @Override
    public Condition<T> addColumnAs(String column, String columnAliasName) {
        return this.addColumn(column + " as " + this.queryOption.quickDAOConfig.databaseContext.databaseProvider.escape(columnAliasName));
    }

    @Override
    public Condition<T> addTableColumn() {
        block3: for (Property property : this.queryOption.queryTableOption.entity.properties) {
            if (null == property.name || property.name.isEmpty() || property.name.equalsIgnoreCase(property.column)) {
                this.queryOption.queryColumnOption.columnList.add(property.column);
                continue;
            }
            DatabaseProvider databaseProvider = this.queryOption.quickDAOConfig.databaseContext.databaseProvider;
            switch (databaseProvider.getDatabaseType()) {
                case Postgresql: {
                    this.queryOption.queryColumnOption.columnList.add(property.column + " " + databaseProvider.escape(property.name));
                    continue block3;
                }
            }
            this.queryOption.queryColumnOption.columnList.add(property.column + " " + property.name);
        }
        return this;
    }

    @Override
    public Condition<T> addExcludeColumn(String ... excludeFields) {
        this.queryOption.queryColumnOption.excludeColumnList.addAll(Arrays.asList(excludeFields));
        return this;
    }

    @Override
    public Condition<T> setColumnTypeMapping(QueryColumnTypeMapping queryColumnTypeMapping) {
        this.queryOption.queryColumnOption.queryColumnTypeMapping = queryColumnTypeMapping;
        return this;
    }

    @Override
    public Condition<T> setColumnTypeMap(String columnLabel, Class type) {
        this.queryOption.queryColumnOption.queryColumnTypeMap.put(columnLabel, type);
        return this;
    }

    @Override
    public Condition<T> addColumn(Condition subCondition) {
        FlowContext flowContext = this.queryOption.quickFlow.startFlow((BusinessFlow)new GetFromConditionStatement()).putTemporaryData("fromCondition", (Object)subCondition).execute();
        String fromConditionStatement = (String)flowContext.checkData("fromConditionStatement");
        List fromConditionParameters = (List)flowContext.getData("fromConditionParameters");
        this.queryOption.queryColumnOption.columnList.add("(" + fromConditionStatement + ")");
        this.queryOption.queryColumnOption.columnParameterList.addAll(fromConditionParameters);
        return this;
    }

    @Override
    public Condition<T> addColumn(Condition subCondition, String columnNameAlias) {
        this.queryOption.setConditionTableAliasName(subCondition);
        FlowContext flowContext = this.queryOption.quickFlow.startFlow((BusinessFlow)new GetFromConditionStatement()).putTemporaryData("fromCondition", (Object)subCondition).execute();
        String fromConditionStatement = (String)flowContext.checkData("fromConditionStatement");
        List fromConditionParameters = (List)flowContext.getData("fromConditionParameters");
        this.queryOption.queryColumnOption.columnList.add("( " + fromConditionStatement + ") " + columnNameAlias);
        this.queryOption.queryColumnOption.columnParameterList.addAll(fromConditionParameters);
        return this;
    }

    @Override
    public Condition<T> addUpdate(String field, Object value) {
        this.queryOption.queryUpdateOption.setList.add(new SQLFragmentEntry(",", field, "{} = ?"));
        this.queryOption.queryUpdateOption.setParameterList.add(value);
        return this;
    }

    @Override
    public Condition<T> addRawUpdate(String update, Object ... parameterList) {
        this.queryOption.queryUpdateOption.setList.add(new SQLFragmentEntry(",", null, update));
        this.queryOption.queryUpdateOption.setParameterList.addAll(Arrays.asList(parameterList));
        return this;
    }

    @Override
    public Condition<T> or(String or, Object ... parameterList) {
        this.queryOption.queryFragmentOption.whereList.add(new SQLFragmentEntry("or", null, or));
        if (null != parameterList && parameterList.length > 0) {
            this.queryOption.queryFragmentOption.whereParameterList.addAll(Arrays.asList(parameterList));
        }
        return this;
    }

    @Override
    public Condition<T> groupBy(String ... fields) {
        for (String field : fields) {
            this.queryOption.queryFragmentOption.groupByList.add(new SQLFragmentEntry(",", field, "{}"));
        }
        return this;
    }

    @Override
    public Condition<T> having(String having, Object ... parameterList) {
        this.queryOption.queryFragmentOption.havingList.add(new SQLFragmentEntry("and", null, having));
        if (null != parameterList && parameterList.length > 0) {
            this.queryOption.queryFragmentOption.havingParameterList.addAll(Arrays.asList(parameterList));
        }
        return this;
    }

    @Override
    public Condition<T> having(String field, String operator, Condition subCondition) {
        this.queryOption.setConditionTableAliasName(subCondition);
        FlowContext flowContext = this.queryOption.quickFlow.startFlow((BusinessFlow)new GetFromConditionStatement()).putTemporaryData("fromCondition", (Object)subCondition).execute();
        String fromConditionStatement = (String)flowContext.checkData("fromConditionStatement");
        List fromConditionParameters = (List)flowContext.getData("fromConditionParameters");
        this.queryOption.queryFragmentOption.havingList.add(new SQLFragmentEntry("and", field, "{}" + operator + " (" + fromConditionStatement + ")"));
        this.queryOption.queryFragmentOption.havingParameterList.addAll(fromConditionParameters);
        return this;
    }

    @Override
    public <E> SubCondition<E, T> crossJoinTable(Class<E> clazz) {
        SubQueryOption subQueryOption = new SubQueryOption();
        subQueryOption.subQueryTableOption.entity = this.queryOption.quickDAOConfig.getEntityByClassName(clazz.getName());
        subQueryOption.subQueryJoinTableOption.join = "cross join";
        subQueryOption.subQueryJoinTableOption.queryOption = this.queryOption;
        subQueryOption.subQueryJoinTableOption.condition = this;
        this.queryOption.subQueryOptionList.add(subQueryOption);
        return new SubConditionImpl(subQueryOption);
    }

    @Override
    public SubCondition<?, T> crossJoinTable(String tableName) {
        SubQueryOption subQueryOption = new SubQueryOption();
        subQueryOption.subQueryTableOption.entity = this.queryOption.quickDAOConfig.getDatabaseEntityByTableName(tableName);
        if (null == subQueryOption.subQueryTableOption.entity) {
            throw new IllegalArgumentException("\u5173\u8054\u8868\u4e0d\u5b58\u5728!\u8868\u540d:" + tableName);
        }
        subQueryOption.subQueryJoinTableOption.join = "cross join";
        subQueryOption.subQueryJoinTableOption.queryOption = this.queryOption;
        subQueryOption.subQueryJoinTableOption.condition = this;
        this.queryOption.subQueryOptionList.add(subQueryOption);
        return new SubConditionImpl(subQueryOption);
    }

    @Override
    public <E> SubCondition<E, T> joinTable(Class<E> clazz, String primaryField, String joinTableField) {
        String compositeFieldName = null;
        if (null != this.queryOption.queryTableOption.entity) {
            compositeFieldName = this.queryOption.queryTableOption.entity.getCompositeFieldName(clazz.getName());
        }
        return this.joinTable(clazz, primaryField, joinTableField, compositeFieldName);
    }

    @Override
    public <E> SubCondition<E, T> joinTable(Class<E> clazz, String primaryField, String joinTableField, String compositeField) {
        SubQueryOption subQueryOption = new SubQueryOption();
        subQueryOption.subQueryTableOption.entity = this.queryOption.quickDAOConfig.getEntityByClassName(clazz.getName());
        subQueryOption.subQueryJoinTableOption.join = "inner join";
        subQueryOption.subQueryJoinTableOption.primaryField = null == this.queryOption.queryTableOption.entity ? primaryField : this.queryOption.queryTableOption.entity.getColumnNameByFieldName(primaryField);
        subQueryOption.subQueryJoinTableOption.joinTableField = null == subQueryOption.subQueryTableOption.entity ? joinTableField : subQueryOption.subQueryTableOption.entity.getColumnNameByFieldName(joinTableField);
        subQueryOption.subQueryJoinTableOption.compositeFieldName = compositeField;
        subQueryOption.subQueryJoinTableOption.queryOption = this.queryOption;
        subQueryOption.subQueryJoinTableOption.condition = this;
        this.queryOption.subQueryOptionList.add(subQueryOption);
        return new SubConditionImpl(subQueryOption);
    }

    @Override
    public <E> SubCondition<E, T> joinTable(Condition<E> joinCondition, String primaryField, String joinConditionField) {
        SubQueryOption subQueryOption = new SubQueryOption();
        subQueryOption.subQueryTableOption.joinCondition = joinCondition;
        subQueryOption.subQueryJoinTableOption.join = "inner join";
        subQueryOption.subQueryJoinTableOption.primaryField = this.queryOption.queryTableOption.entity.getColumnNameByFieldName(primaryField);
        subQueryOption.subQueryJoinTableOption.joinTableField = joinConditionField;
        subQueryOption.subQueryJoinTableOption.queryOption = this.queryOption;
        subQueryOption.subQueryJoinTableOption.condition = this;
        this.queryOption.subQueryOptionList.add(subQueryOption);
        return new SubConditionImpl(subQueryOption);
    }

    @Override
    public SubCondition<?, T> joinTable(String tableName, String primaryField, String joinTableField) {
        SubQueryOption subQueryOption = new SubQueryOption();
        subQueryOption.subQueryTableOption.entity = this.queryOption.quickDAOConfig.getDatabaseEntityByTableName(tableName);
        if (null == subQueryOption.subQueryTableOption.entity) {
            throw new IllegalArgumentException("\u5173\u8054\u8868\u4e0d\u5b58\u5728!\u8868\u540d:" + tableName);
        }
        subQueryOption.subQueryJoinTableOption.join = "inner join";
        subQueryOption.subQueryJoinTableOption.primaryField = this.queryOption.queryTableOption.entity.getColumnNameByFieldName(primaryField);
        subQueryOption.subQueryJoinTableOption.joinTableField = joinTableField;
        subQueryOption.subQueryJoinTableOption.queryOption = this.queryOption;
        subQueryOption.subQueryJoinTableOption.condition = this;
        this.queryOption.subQueryOptionList.add(subQueryOption);
        return new SubConditionImpl(subQueryOption);
    }

    @Override
    public Condition<T> order(String field, String asc) {
        this.queryOption.queryFragmentOption.orderByList.add(new SQLFragmentEntry(",", field, "{} " + asc));
        return this;
    }

    @Override
    public Condition<T> orderBy(String ... fields) {
        for (String field : fields) {
            this.queryOption.queryFragmentOption.orderByList.add(new SQLFragmentEntry(",", field, "{} asc"));
        }
        return this;
    }

    @Override
    public Condition<T> orderByDesc(String ... fields) {
        for (String field : fields) {
            this.queryOption.queryFragmentOption.orderByList.add(new SQLFragmentEntry(",", field, "{} desc"));
        }
        return this;
    }

    @Override
    public Condition<T> orderByRaw(String orderBy) {
        this.queryOption.queryFragmentOption.orderByList.add(new SQLFragmentEntry(",", null, orderBy));
        return this;
    }

    @Override
    public Condition<T> limit(long offset, long limit) {
        switch (this.queryOption.quickDAOConfig.databaseContext.databaseProvider.getDatabaseType()) {
            case Postgresql: {
                this.queryOption.queryPagingOption.limit = "limit " + limit + " offset " + offset;
                break;
            }
            case Oracle: {
                ConditionImpl<T> fromCondition = new ConditionImpl<T>(this, this.queryOption.quickFlow, this.queryOption.quickDAOConfig);
                Condition subCondition = fromCondition.tableAliasName("a").addColumn("a.*", "rownum rn").addQuery("rownum", "<=", limit + offset);
                Condition<T> condition = new ConditionImpl<T>(subCondition, this.queryOption.quickFlow, this.queryOption.quickDAOConfig).tableAliasName("b").addQuery("rn", ">=", offset + 1L);
                if ("JSONObject".equals(this.queryOption.queryTableOption.entity.clazz.getSimpleName())) {
                    condition.addColumn("b.*");
                } else {
                    for (Property property : this.queryOption.queryTableOption.entity.properties) {
                        condition.addColumn("b." + this.queryOption.queryTableOption.tableAliasName + "_" + property.column);
                    }
                    if (this.queryOption.queryColumnOption.compositeField) {
                        for (SubQueryOption subQueryOption : this.queryOption.subQueryOptionList) {
                            for (Property property : subQueryOption.subQueryTableOption.entity.properties) {
                                condition.addColumn("b." + subQueryOption.subQueryTableOption.tableAliasName + "_" + property.column);
                            }
                        }
                    }
                }
                return condition;
            }
            case SQLServer: {
                this.queryOption.queryPagingOption.limit = "offset " + offset + " rows fetch next " + limit + " rows only";
                break;
            }
            default: {
                this.queryOption.queryPagingOption.limit = "limit " + offset + "," + limit;
            }
        }
        return this;
    }

    @Override
    public Condition<T> page(int pageNum, int pageSize) {
        switch (this.queryOption.quickDAOConfig.databaseContext.databaseProvider.getDatabaseType()) {
            case Postgresql: {
                this.queryOption.queryPagingOption.limit = "limit " + pageSize + " offset " + (pageNum - 1) * pageSize;
                break;
            }
            case Oracle: {
                ConditionImpl condition = (ConditionImpl)this.limit((pageNum - 1) * pageSize, pageSize);
                condition.queryOption.queryPagingOption.pageVo = new PageVo();
                condition.queryOption.queryPagingOption.pageVo.setPageSize(pageSize);
                condition.queryOption.queryPagingOption.pageVo.setCurrentPage(pageNum);
                return condition;
            }
            case SQLServer: {
                this.queryOption.queryPagingOption.limit = "offset " + (pageNum - 1) * pageSize + " rows  fetch next " + pageSize + " rows only";
                break;
            }
            default: {
                this.queryOption.queryPagingOption.limit = "limit " + (pageNum - 1) * pageSize + "," + pageSize;
            }
        }
        this.queryOption.queryPagingOption.pageVo.setPageSize(pageSize);
        this.queryOption.queryPagingOption.pageVo.setCurrentPage(pageNum);
        return this;
    }

    @Override
    public Condition<T> compositeField() {
        this.queryOption.queryColumnOption.compositeField = true;
        return this;
    }

    @Override
    public LambdaCondition<T> lambdaCondition() {
        LambdaConditionInvocationHandler invocationHandler = new LambdaConditionInvocationHandler(this);
        LambdaCondition lambdaCondition = (LambdaCondition)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{LambdaCondition.class}, invocationHandler);
        return lambdaCondition;
    }

    @Override
    public Response<T> execute() {
        if (this.hasExecute) {
            throw new IllegalArgumentException("\u8be5Condition\u5df2\u7ecf\u6267\u884c\u8fc7,\u4e0d\u80fd\u518d\u6b21\u6267\u884c!");
        }
        boolean addColumnAliasName = false;
        if (!this.queryOption.subQueryOptionList.isEmpty()) {
            addColumnAliasName = true;
        }
        QueryContext queryContext = new QueryContext();
        queryContext.queryOption = this.queryOption;
        this.queryOption.quickFlow.startFlow((CompositeBusinessFlow)new ExecuteConditionCompositeBusiness()).putTemporaryData("queryContext", (Object)queryContext).putTemporaryData("addColumnAliasName", (Object)addColumnAliasName).putTemporaryData("addTableAliasName", (Object)true).execute();
        this.hasExecute = true;
        ResponseImpl response = new ResponseImpl(queryContext);
        return response;
    }

    @Override
    public Condition clone() {
        FlowContext flowContext = this.queryOption.quickFlow.startFlow((BusinessFlow)new CloneConditionFlow()).putCurrentCompositeFlowData("queryOption", (Object)this.queryOption, new FlowDataFeature[0]).execute();
        QueryOption cloneQueryOption = (QueryOption)flowContext.checkData("cloneQueryOption");
        return new ConditionImpl<T>(cloneQueryOption);
    }

    private void addInQuery(String field, Object[] values, String in) {
        if (null == values || values.length == 0) {
            this.queryOption.queryFragmentOption.whereList.add(new SQLFragmentEntry("and", null, "1 = 2"));
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(" {} " + in + " (");
        for (int i = 0; i < values.length; ++i) {
            builder.append("?,");
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append(")");
        this.queryOption.queryFragmentOption.whereList.add(new SQLFragmentEntry("and", field, builder.toString()));
        this.queryOption.queryFragmentOption.whereParameterList.addAll(Arrays.asList(values));
    }

    private void addExistSubQuery(Condition subCondition, String exist) {
        this.queryOption.setConditionTableAliasName(subCondition);
        FlowContext flowContext = this.queryOption.quickFlow.startFlow((BusinessFlow)new GetFromConditionStatement()).putTemporaryData("fromCondition", (Object)subCondition).execute();
        String fromConditionStatement = (String)flowContext.checkData("fromConditionStatement");
        List fromConditionParameters = (List)flowContext.getData("fromConditionParameters");
        this.queryOption.queryFragmentOption.whereList.add(new SQLFragmentEntry("and", null, exist + " (" + fromConditionStatement + ")"));
        this.queryOption.queryFragmentOption.whereParameterList.addAll(fromConditionParameters);
    }
}

