/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.database.dql.query.flow.common;

import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.entity.Entity;
import cn.schoolwow.quickdao.module.database.parent.domain.ResultSetConsumer;
import cn.schoolwow.quickdao.module.database.parent.flow.executor.ExecuteQueryConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.domain.FlowDataFeature;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.util.domain.query.instance.QueryInstance;
import java.sql.ResultSet;
import java.util.Arrays;

public class GetCountByIdFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        this.setStatement(flowContext);
        this.setParameters(flowContext);
        this.executeStatement(flowContext);
    }

    public String name() {
        return "\u6839\u636eid\u5b57\u6bb5\u67e5\u8be2\u8bb0\u5f55\u4e2a\u6570";
    }

    private void setStatement(FlowContext flowContext) {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkInstanceData(QuickDAOConfig.class);
        Entity entity = (Entity)flowContext.checkData("entity");
        String key = "selectCountById_" + entity.tableName + "_" + quickDAOConfig.databaseContext.databaseProvider.name();
        if (!quickDAOConfig.databaseContext.statementCache.containsKey(key)) {
            StringBuilder sqlBuilder = new StringBuilder();
            sqlBuilder.append("select count(1) from " + quickDAOConfig.databaseContext.databaseProvider.escape(entity.tableName) + " where ");
            sqlBuilder.append(quickDAOConfig.databaseContext.databaseProvider.escape(entity.id.column) + " = ?");
            quickDAOConfig.databaseContext.statementCache.put(key, sqlBuilder.toString());
        }
        String sql = quickDAOConfig.databaseContext.statementCache.get(key);
        flowContext.putTemporaryData("sql", (Object)sql);
    }

    private void setParameters(FlowContext flowContext) {
        Entity entity = (Entity)flowContext.checkData("entity");
        Object instance = flowContext.checkData("instance");
        Object idValue = QueryInstance.newQuery((Object)instance).execute().getSingleFieldValue(entity.id.name);
        flowContext.putTemporaryData("parameters", Arrays.asList(idValue));
    }

    private void executeStatement(final FlowContext flowContext) {
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u6839\u636eId\u5b57\u6bb5\u67e5\u8be2\u8bb0\u5f55\u4e2a\u6570").putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                if (resultSet.next()) {
                    flowContext.putData("count", (Object)resultSet.getLong(1), new FlowDataFeature[0]);
                }
            }
        }, new FlowDataFeature[0]).execute();
    }
}

