/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.database.dql.query.service.fetch;

import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.entity.Entity;
import cn.schoolwow.quickdao.domain.entity.Property;
import cn.schoolwow.quickdao.module.database.dql.response.flow.common.GetResultSetArrayFlow;
import cn.schoolwow.quickdao.module.database.parent.domain.GetStatementSupplier;
import cn.schoolwow.quickdao.module.database.parent.domain.ResultSetConsumer;
import cn.schoolwow.quickdao.module.database.parent.flow.GetAndCacheStatementFlow;
import cn.schoolwow.quickdao.module.database.parent.flow.executor.ExecuteQueryConnectionFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.domain.FlowDataFeature;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.sql.ResultSet;
import java.util.Arrays;

public class FetchListFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        this.setStatement(flowContext);
        this.setParameters(flowContext);
        this.executeStatement(flowContext);
    }

    public String name() {
        return "\u5355\u5b57\u6bb5\u67e5\u8be2";
    }

    private void setStatement(FlowContext flowContext) {
        final QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkInstanceData(QuickDAOConfig.class);
        final Entity entity = (Entity)flowContext.checkData("entity");
        final String column = (String)flowContext.checkData("column");
        final Property property = entity.getPropertyByFieldNameOrColumnName(column);
        String sqlCacheName = "fetchList_" + entity.tableName + "_" + column + "_" + quickDAOConfig.databaseContext.databaseProvider.name();
        flowContext.startFlow((BusinessFlow)new GetAndCacheStatementFlow()).putCurrentCompositeFlowData("sqlCacheName", (Object)sqlCacheName, new FlowDataFeature[0]).putTemporaryData("getStatementSupplier", (Object)new GetStatementSupplier(){

            @Override
            public String getStatement() {
                StringBuilder sqlBuilder = new StringBuilder("select ");
                for (Property property2 : entity.properties) {
                    sqlBuilder.append(quickDAOConfig.databaseContext.databaseProvider.escape(property2.column) + ",");
                }
                sqlBuilder.deleteCharAt(sqlBuilder.length() - 1);
                sqlBuilder.append(" from " + quickDAOConfig.databaseContext.databaseProvider.escape(entity.tableName));
                sqlBuilder.append(" where " + quickDAOConfig.databaseContext.databaseProvider.escape(column) + " = " + (null == property.function ? "?" : property.function));
                return sqlBuilder.toString();
            }
        }).execute();
    }

    private void setParameters(FlowContext flowContext) {
        Object value = flowContext.checkData("value");
        flowContext.putTemporaryData("parameters", Arrays.asList(value));
    }

    private void executeStatement(final FlowContext flowContext) throws Exception {
        flowContext.startFlow((BusinessFlow)new ExecuteQueryConnectionFlow()).putTemporaryData("name", (Object)"\u5355\u5b57\u6bb5\u67e5\u8be2").putReturnData("resultSetConsumer", (Object)new ResultSetConsumer(){

            @Override
            public void consumeResultSet(ResultSet resultSet) throws Exception {
                flowContext.startFlow((BusinessFlow)new GetResultSetArrayFlow()).putTemporaryData("resultSet", (Object)resultSet).execute();
            }
        }, new FlowDataFeature[0]).execute();
    }
}

