/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.database.parent.flow.executor.common;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetFormatStatementFlow
implements BusinessFlow {
    private Logger logger = LoggerFactory.getLogger(SetFormatStatementFlow.class);
    private static final String PLACEHOLDER = "** NOT SPECIFIED **";
    private static final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat simpleTimeFormat = new SimpleDateFormat("HH:mm:ss");
    private static final SimpleDateFormat simpleDateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
    private static final DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        String sql = (String)flowContext.checkData("sql");
        Collection parameters = (Collection)flowContext.getData("parameters");
        if (null == parameters || parameters.isEmpty()) {
            flowContext.putTemporaryData("formatSQL", (Object)sql);
            flowContext.brokenCurrentFlow("");
        }
        int parameterCount = 0;
        for (int i = 0; i < sql.length(); ++i) {
            if (sql.charAt(i) != '?') continue;
            ++parameterCount;
        }
        if (parameterCount != parameters.size()) {
            this.logger.warn("\u53c2\u6570\u4e2a\u6570\u4e0d\u5339\u914d!\u9884\u671f\u53c2\u6570\u4e2a\u6570:{},\u5b9e\u9645\u53c2\u6570\u4e2a\u6570:{},\r\n\u8bed\u53e5:{}\r\n\u53c2\u6570\u5217\u8868:{}", new Object[]{parameterCount, parameters.size(), sql, parameters});
            throw new IllegalArgumentException("\u53c2\u6570\u4e2a\u6570\u4e0d\u5339\u914d!\u9884\u671f\u4e2a\u6570:" + parameterCount + ",\u5b9e\u9645\u4e2a\u6570:" + parameters.size());
        }
        StringBuilder sqlBuilder = new StringBuilder(sql.replace("?", PLACEHOLDER));
        for (Object parameter : parameters) {
            String parameterPlaceHolder = this.getParameterPlaceHolder(parameter);
            int indexOf = sqlBuilder.indexOf(PLACEHOLDER);
            sqlBuilder.replace(indexOf, indexOf + PLACEHOLDER.length(), parameterPlaceHolder);
        }
        String formatSQL = sqlBuilder.toString();
        flowContext.putTemporaryData("formatSQL", (Object)formatSQL);
    }

    public String name() {
        return "\u8bbe\u7f6e\u683c\u5f0f\u5316SQL\u8bed\u53e5";
    }

    private String getParameterPlaceHolder(Object parameter) {
        if (null == parameter) {
            return "null";
        }
        String parameterSQL = parameter.toString();
        switch (parameter.getClass().getName()) {
            case "boolean": {
                boolean value = (Boolean)parameter;
                parameterSQL = value ? "1" : "0";
                break;
            }
            case "java.lang.String": 
            case "com.alibaba.fastjson.JSONObject": 
            case "com.alibaba.fastjson.JSONArray": {
                parameterSQL = "'" + parameter.toString() + "'";
                break;
            }
            case "java.util.Date": {
                Date date = (Date)parameter;
                parameterSQL = "'" + simpleDateFormat.format(date) + "'";
                break;
            }
            case "java.sql.Date": {
                java.sql.Date date = (java.sql.Date)parameter;
                parameterSQL = "'" + simpleDateFormat.format(date) + "'";
                break;
            }
            case "java.sql.Time": {
                Time time = (Time)parameter;
                parameterSQL = "'" + simpleTimeFormat.format(time) + "'";
                break;
            }
            case "java.sql.Timestamp": {
                Timestamp timestamp = (Timestamp)parameter;
                parameterSQL = "'" + simpleDateTimeFormat.format(timestamp) + "'";
                break;
            }
            case "java.time.LocalDate": {
                LocalDate localDate = (LocalDate)parameter;
                parameterSQL = "'" + localDate.format(dateFormatter) + "'";
                break;
            }
            case "java.time.LocalDateTime": {
                LocalDateTime localDateTime = (LocalDateTime)parameter;
                parameterSQL = "'" + localDateTime.format(dateTimeFormatter) + "'";
            }
        }
        return parameterSQL;
    }
}

