/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.entity.flow.annotation;

import cn.schoolwow.quickdao.annotation.ColumnName;
import cn.schoolwow.quickdao.annotation.ColumnType;
import cn.schoolwow.quickdao.annotation.ColumnTypeRepeatable;
import cn.schoolwow.quickdao.annotation.Comment;
import cn.schoolwow.quickdao.annotation.Constraint;
import cn.schoolwow.quickdao.annotation.ForeignKey;
import cn.schoolwow.quickdao.annotation.Id;
import cn.schoolwow.quickdao.annotation.IdStrategy;
import cn.schoolwow.quickdao.annotation.Index;
import cn.schoolwow.quickdao.annotation.Indexes;
import cn.schoolwow.quickdao.annotation.TableField;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.database.ddl.IndexField;
import cn.schoolwow.quickdao.domain.database.parent.DatabaseType;
import cn.schoolwow.quickdao.domain.entity.Entity;
import cn.schoolwow.quickdao.domain.entity.Property;
import cn.schoolwow.quickdao.util.StringUtil;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;

public class GetPropertyAnnotationFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        Entity entity = (Entity)flowContext.checkData("entity");
        Property property = new Property();
        property.entity = entity;
        flowContext.putTemporaryData("property", (Object)property);
        this.setColumnType(flowContext);
        this.setConstraint(flowContext);
        this.setIndexField(flowContext);
    }

    public String name() {
        return "\u63d0\u53d6\u5b57\u6bb5\u6ce8\u89e3";
    }

    private void setColumnType(FlowContext flowContext) {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkInstanceData(QuickDAOConfig.class);
        DatabaseType databaseType = (DatabaseType)((Object)flowContext.checkData("databaseType"));
        Field field = (Field)flowContext.checkData("field");
        Property property = (Property)flowContext.checkData("property");
        property.column = null != field.getAnnotation(ColumnName.class) ? field.getAnnotation(ColumnName.class).value() : StringUtil.camel2Underline(field.getName());
        property.columnLabel = property.name = field.getName();
        property.clazz = field.getType();
        property.className = field.getType().getName();
        if (null != field.getAnnotation(ColumnType.class)) {
            property.columnType = field.getAnnotation(ColumnType.class).value();
        } else if (null != field.getAnnotation(ColumnTypeRepeatable.class)) {
            ColumnTypeRepeatable columnTypeRepeatable = field.getAnnotation(ColumnTypeRepeatable.class);
            for (ColumnType columnType : columnTypeRepeatable.value()) {
                if (!columnType.databaseType().equals((Object)databaseType)) continue;
                property.columnType = columnType.value();
                break;
            }
            if (null == property.columnType) {
                for (ColumnType columnType : columnTypeRepeatable.value()) {
                    if (!columnType.databaseType().equals((Object)DatabaseType.CURRENT)) continue;
                    property.columnType = columnType.value();
                    break;
                }
            }
        } else {
            property.columnType = quickDAOConfig.databaseContext.databaseProvider.convertJavaTypeToColumnType(property.className);
        }
        if (property.columnType.contains("(") && property.columnType.contains(")")) {
            property.range = property.columnType.substring(property.columnType.indexOf("(") + 1, property.columnType.indexOf(")"));
            property.columnType = property.columnType.substring(0, property.columnType.indexOf("("));
        }
        if (null != field.getDeclaredAnnotation(Comment.class)) {
            property.comment = field.getDeclaredAnnotation(Comment.class).value();
        }
    }

    private void setConstraint(FlowContext flowContext) {
        TableField tableField;
        Id id;
        Entity entity = (Entity)flowContext.checkData("entity");
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkInstanceData(QuickDAOConfig.class);
        Field field = (Field)flowContext.checkData("field");
        Property property = (Property)flowContext.checkData("property");
        Constraint constraint = field.getDeclaredAnnotation(Constraint.class);
        if (null != constraint) {
            property.notNull = constraint.notNull();
            if (null != property.check) {
                if (!property.check.isEmpty() && !property.check.contains("(")) {
                    property.check = "(" + property.check + ")";
                }
                property.check = property.check.replace("#{" + property.name + "}", property.column);
                property.escapeCheck = property.check.replace(property.column, quickDAOConfig.databaseContext.databaseProvider.escape(property.column));
            }
            property.defaultValue = constraint.defaultValue();
        }
        if (null != (id = field.getDeclaredAnnotation(Id.class))) {
            property.id = true;
            property.strategy = id.strategy();
        }
        if (null != (tableField = field.getDeclaredAnnotation(TableField.class))) {
            if (!tableField.function().isEmpty()) {
                String databaseName = quickDAOConfig.databaseContext.databaseProvider.name();
                if ("sqlite".equalsIgnoreCase(databaseName) || "h2".equalsIgnoreCase(databaseName) || "sqlserver".equalsIgnoreCase(databaseName)) {
                    flowContext.remark("sqlite,h2,sqlserver\u6570\u636e\u5e93\u4e0d\u652f\u6301\u6307\u5b9afunction\u5c5e\u6027!");
                } else {
                    property.function = tableField.function().replace("#{" + property.name + "}", "?");
                }
            }
            property.createdAt = tableField.createdAt();
            if (property.createdAt) {
                property.comment = "\u521b\u5efa\u65f6\u95f4";
            }
            property.updateAt = tableField.updatedAt();
            if (property.updateAt) {
                property.comment = "\u66f4\u65b0\u65f6\u95f4";
            }
        }
        property.foreignKey = field.getDeclaredAnnotation(ForeignKey.class);
        if (property.id) {
            entity.id = property;
            property.notNull = true;
            property.comment = "\u81ea\u589eid";
            if (property.strategy == IdStrategy.AutoIncrement && null != quickDAOConfig.entityOption.idStrategy) {
                property.strategy = quickDAOConfig.entityOption.idStrategy;
            }
        }
        if (null != property.foreignKey) {
            entity.foreignKeyProperties.add(property);
        }
    }

    private void setIndexField(FlowContext flowContext) {
        Indexes indexes;
        Entity entity = (Entity)flowContext.checkData("entity");
        Field field = (Field)flowContext.checkData("field");
        Property property = (Property)flowContext.checkData("property");
        ArrayList<Index> indexList = new ArrayList<Index>();
        if (null != field.getDeclaredAnnotation(Index.class)) {
            indexList.add(field.getDeclaredAnnotation(Index.class));
        }
        if (null != (indexes = field.getDeclaredAnnotation(Indexes.class)) && indexes.value().length > 0) {
            indexList.addAll(Arrays.asList(indexes.value()));
        }
        for (Index index : indexList) {
            IndexField indexField = new IndexField();
            indexField.tableName = entity.tableName;
            indexField.indexType = index.indexType();
            indexField.indexName = !index.indexName().isEmpty() ? index.indexName() : entity.tableName + "_" + indexField.indexType.name().toLowerCase() + "_" + property.column;
            indexField.using = index.using();
            indexField.comment = index.comment();
            indexField.columns.add(property.column);
            entity.indexFieldList.add(indexField);
        }
    }
}

