/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.initial.flow.datasource;

import cn.schoolwow.quickdao.module.initial.flow.database.CheckDataSourceFlow;
import cn.schoolwow.quickdao.module.initial.flow.database.ExecuteCreateDatabaseFlow;
import cn.schoolwow.quickdao.module.initial.flow.database.SetCreateDatabaseStatementFlow;
import cn.schoolwow.quickdao.module.initial.flow.database.SetDatabaseNameFlow;
import cn.schoolwow.quickdao.module.initial.flow.database.SetQueryDatabaseStatementFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.domain.FlowDataFeature;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.baomidou.dynamic.datasource.DynamicRoutingDataSource;
import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;

public class CreateDatabaseFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        this.hikariDataSource(flowContext);
        this.dynamicRoutingDataSource(flowContext);
    }

    public String name() {
        return "\u521b\u5efa\u6570\u636e\u5e93";
    }

    private void hikariDataSource(FlowContext flowContext) {
        DataSource dataSource = (DataSource)flowContext.checkData("dataSource");
        try {
            ClassLoader.getSystemClassLoader().loadClass("com.zaxxer.hikari.HikariDataSource");
        }
        catch (ClassNotFoundException e) {
            return;
        }
        if (dataSource instanceof HikariDataSource) {
            HikariDataSource hikariDataSource = (HikariDataSource)dataSource;
            flowContext.putTemporaryData("driverClassName", (Object)hikariDataSource.getDriverClassName());
            flowContext.putTemporaryData("jdbcUrl", (Object)hikariDataSource.getJdbcUrl());
            if (null != hikariDataSource.getUsername()) {
                flowContext.putTemporaryData("username", (Object)hikariDataSource.getUsername());
            }
            if (null != hikariDataSource.getPassword()) {
                flowContext.putTemporaryData("password", (Object)hikariDataSource.getPassword());
            }
            flowContext.startFlow((BusinessFlow)new CheckDataSourceFlow()).next((BusinessFlow)new SetDatabaseNameFlow()).next((BusinessFlow)new SetQueryDatabaseStatementFlow()).next((BusinessFlow)new SetCreateDatabaseStatementFlow()).next((BusinessFlow)new ExecuteCreateDatabaseFlow()).execute();
        }
    }

    private void dynamicRoutingDataSource(FlowContext flowContext) {
        DataSource dataSource = (DataSource)flowContext.checkData("dataSource");
        try {
            ClassLoader.getSystemClassLoader().loadClass("com.baomidou.dynamic.datasource.DynamicRoutingDataSource");
        }
        catch (ClassNotFoundException e) {
            return;
        }
        if (dataSource instanceof DynamicRoutingDataSource) {
            DynamicRoutingDataSource dynamicRoutingDataSource = (DynamicRoutingDataSource)dataSource;
            for (DataSource singleDataSource : dynamicRoutingDataSource.getDataSources().values()) {
                flowContext.putCurrentFlowData("dataSource", (Object)singleDataSource, new FlowDataFeature[0]);
                this.hikariDataSource(flowContext);
            }
        }
    }
}

