/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.initial.flow.datasource;

import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.exception.SQLRuntimeException;
import cn.schoolwow.quickdao.domain.provider.DatabaseProvider;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.sql.Connection;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitialQuickDAOConfigDataSourceFlow
implements BusinessFlow {
    private Logger logger = LoggerFactory.getLogger(InitialQuickDAOConfigDataSourceFlow.class);

    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        DataSource dataSource = (DataSource)flowContext.checkData("dataSource");
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkInstanceData(QuickDAOConfig.class);
        List databaseProviderList = (List)flowContext.checkData("databaseProviderList");
        try (Connection connection = dataSource.getConnection();){
            connection.setAutoCommit(false);
            String jdbcUrl = connection.getMetaData().getURL();
            for (DatabaseProvider databaseProvider : databaseProviderList) {
                if (!jdbcUrl.contains("jdbc:" + databaseProvider.name())) continue;
                quickDAOConfig.databaseContext.databaseProvider = databaseProvider;
                break;
            }
            if (null == quickDAOConfig.databaseContext.databaseProvider) {
                throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b!jdbcUrl:" + jdbcUrl);
            }
            quickDAOConfig.databaseContext.databaseName = connection.getCatalog();
            this.logger.info("[\u6570\u636e\u6e90]\u7c7b\u578b:{},\u5730\u5740:{}", (Object)quickDAOConfig.databaseContext.databaseProvider.name(), (Object)jdbcUrl);
        }
        catch (Exception e) {
            throw new SQLRuntimeException(e);
        }
        quickDAOConfig.databaseContext.dataSource = dataSource;
    }

    public String name() {
        return "\u521d\u59cb\u5316\u5168\u5c40\u914d\u7f6e\u7684\u6570\u636e\u5e93\u8fde\u63a5\u6c60\u4fe1\u606f";
    }
}

