/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.initial.flow.table;

import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.entity.Entity;
import cn.schoolwow.quickdao.domain.entity.Property;
import cn.schoolwow.quickdao.module.database.ddl.service.table.action.CreateTableFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AutomaticCreateTableFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkInstanceData(QuickDAOConfig.class);
        if (!quickDAOConfig.databaseOption.automaticCreateTable) {
            flowContext.remark("\u8df3\u8fc7\u81ea\u52a8\u5efa\u8868");
            return;
        }
        Collection<Entity> entityList = quickDAOConfig.databaseContext.entityMap.values();
        for (Entity entity : entityList) {
            if (!entity.foreignKeyProperties.isEmpty()) continue;
            this.createEntityTable(entity, flowContext);
        }
        ArrayList<Entity> foreignKeyEntityList = new ArrayList<Entity>();
        for (Entity entity : entityList) {
            if (entity.foreignKeyProperties.isEmpty()) continue;
            foreignKeyEntityList.clear();
            this.getForeignKeyEntityList(entity, foreignKeyEntityList, flowContext);
            for (Entity foreignKeyEntity : foreignKeyEntityList) {
                this.createEntityTable(foreignKeyEntity, flowContext);
            }
            this.createEntityTable(entity, flowContext);
        }
    }

    public String name() {
        return "\u81ea\u52a8\u5efa\u8868";
    }

    private void getForeignKeyEntityList(Entity entity, List<Entity> foreignKeyEntityList, FlowContext flowContext) {
        if (entity.foreignKeyProperties.isEmpty()) {
            if (!foreignKeyEntityList.contains(entity)) {
                foreignKeyEntityList.add(entity);
            }
            return;
        }
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkInstanceData(QuickDAOConfig.class);
        for (Property property : entity.foreignKeyProperties) {
            Entity foreignKeyEntity = quickDAOConfig.getEntityByClassName(property.foreignKey.table().getName());
            if (foreignKeyEntity.tableName.equals(entity.tableName)) continue;
            this.getForeignKeyEntityList(foreignKeyEntity, foreignKeyEntityList, flowContext);
        }
    }

    private void createEntityTable(Entity entity, FlowContext flowContext) {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkInstanceData(QuickDAOConfig.class);
        Entity databaseEntity = quickDAOConfig.getDatabaseEntityByTableName(entity.tableName);
        if (null == databaseEntity) {
            flowContext.startFlow((BusinessFlow)new CreateTableFlow()).putTemporaryData("entity", (Object)entity).execute();
        }
    }
}

