/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.initial.flow.table;

import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.entity.Entity;
import cn.schoolwow.quickdao.domain.entity.Property;
import cn.schoolwow.quickdao.module.database.ddl.flow.column.DropTableColumnFlow;
import cn.schoolwow.quickdao.module.database.ddl.flow.common.DeleteDatabaseEntityCacheFlow;
import cn.schoolwow.quickdao.module.database.ddl.flow.index.GetEntityIndexListFlow;
import cn.schoolwow.quickdao.module.database.ddl.flow.property.GetEntityPropertyListFlow;
import cn.schoolwow.quickdao.module.database.ddl.flow.table.DropTableFlow;
import cn.schoolwow.quickdao.module.database.ddl.flow.table.GetEntityListFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AutomaticDeleteTableAndPropertyFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkInstanceData(QuickDAOConfig.class);
        if (!quickDAOConfig.databaseOption.automaticDeleteTableAndProperty) {
            flowContext.remark("\u8df3\u8fc7\u81ea\u52a8\u5220\u9664\u591a\u4f59\u8868\u548c\u5c5e\u6027");
            return;
        }
        Map<String, Entity> entityMap = quickDAOConfig.databaseContext.entityMap;
        if (null == entityMap || entityMap.isEmpty()) {
            flowContext.remark("\u672a\u626b\u63cf\u5230\u4efb\u4f55\u5b9e\u4f53\u7c7b!\u8bf7\u8bbe\u7f6e\u5305\u8def\u5f84\u6216\u8005\u5b9e\u4f53\u7c7b!");
            return;
        }
        List databaseEntityList = (List)flowContext.getQuickFlow().executeFlow(new BusinessFlow[]{new GetEntityListFlow(), new GetEntityPropertyListFlow(), new GetEntityIndexListFlow()}).checkData("entityList");
        ArrayList<String> dropTableNameList = new ArrayList<String>();
        HashMap dropPropertyMap = new HashMap();
        for (Entity entity : databaseEntityList) {
            Entity sourceEntity = null;
            for (Entity _sourceEntity : entityMap.values()) {
                if (!_sourceEntity.tableName.equalsIgnoreCase(entity.tableName)) continue;
                sourceEntity = _sourceEntity;
                break;
            }
            if (null == sourceEntity) {
                dropTableNameList.add(entity.tableName);
                continue;
            }
            for (Property dbProperty : entity.properties) {
                boolean dbPropertyExists = false;
                for (Property propertyItem : sourceEntity.properties) {
                    if (!dbProperty.column.equalsIgnoreCase(propertyItem.column)) continue;
                    dbPropertyExists = true;
                    break;
                }
                if (dbPropertyExists) continue;
                if (!dropPropertyMap.containsKey(entity.tableName)) {
                    dropPropertyMap.put(entity.tableName, new ArrayList());
                }
                ((List)dropPropertyMap.get(entity.tableName)).add(dbProperty.column);
            }
        }
        for (String string : dropTableNameList) {
            flowContext.startFlow((BusinessFlow)new DropTableFlow()).next((BusinessFlow)new DeleteDatabaseEntityCacheFlow()).putTemporaryData("tableName", (Object)string).execute();
        }
        for (Map.Entry entry : dropPropertyMap.entrySet()) {
            for (String column : (List)entry.getValue()) {
                flowContext.getQuickFlow().startFlow((BusinessFlow)new DropTableColumnFlow()).putTemporaryData("tableName", entry.getKey()).putTemporaryData("columnName", (Object)column).execute();
            }
            flowContext.startFlow((BusinessFlow)new DeleteDatabaseEntityCacheFlow()).putTemporaryData("tableName", entry.getKey()).execute();
        }
    }

    public String name() {
        return "\u81ea\u52a8\u5220\u9664\u591a\u4f59\u8868\u548c\u5c5e\u6027";
    }
}

