/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.initial.flow.table;

import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.entity.DatabaseUpgrade;
import cn.schoolwow.quickdao.domain.entity.Entity;
import cn.schoolwow.quickdao.domain.entity.Property;
import cn.schoolwow.quickdao.domain.entity.PropertyOption;
import cn.schoolwow.quickdao.domain.entity.SqlLog;
import cn.schoolwow.quickdao.module.database.ddl.flow.column.AlterTableColumnFlow;
import cn.schoolwow.quickdao.module.database.ddl.flow.property.GetEntityPropertyListFlow;
import cn.schoolwow.quickdao.module.database.ddl.flow.table.GetEntityListFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AutomaticUpdatePropertyFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkInstanceData(QuickDAOConfig.class);
        if (!quickDAOConfig.databaseOption.automaticUpdateProperty) {
            flowContext.remark("\u8df3\u8fc7\u81ea\u52a8\u66f4\u65b0\u5c5e\u6027");
            return;
        }
        Map<String, Entity> entityMap = quickDAOConfig.databaseContext.entityMap;
        if (null == entityMap || entityMap.isEmpty()) {
            flowContext.remark("\u672a\u626b\u63cf\u5230\u4efb\u4f55\u5b9e\u4f53\u7c7b!\u8bf7\u8bbe\u7f6e\u5305\u8def\u5f84\u6216\u8005\u5b9e\u4f53\u7c7b!");
            return;
        }
        List databaseEntityList = (List)flowContext.getQuickFlow().executeFlow(new BusinessFlow[]{new GetEntityListFlow(), new GetEntityPropertyListFlow()}).checkData("entityList");
        HashMap alterPropertyMap = new HashMap();
        for (Entity entity : entityMap.values()) {
            for (Entity databaseEntity : databaseEntityList) {
                if (entity.clazz.getSimpleName().equalsIgnoreCase(DatabaseUpgrade.class.getSimpleName()) || entity.clazz.getSimpleName().equalsIgnoreCase(SqlLog.class.getSimpleName()) || null != quickDAOConfig.databaseOption.updateTableNameList && !quickDAOConfig.databaseOption.updateTableNameList.isEmpty() && !quickDAOConfig.databaseOption.updateTableNameList.contains(entity.tableName) || !entity.tableName.equalsIgnoreCase(databaseEntity.tableName)) continue;
                for (Property property : entity.properties) {
                    for (Property databaseProperty : databaseEntity.properties) {
                        if (!property.column.equalsIgnoreCase(databaseProperty.column) || !this.shouldUpdate(property, databaseProperty)) continue;
                        PropertyOption propertyOption = new PropertyOption();
                        propertyOption.id = property.id;
                        propertyOption.strategy = property.strategy;
                        propertyOption.notNull = property.notNull;
                        propertyOption.column = property.column;
                        propertyOption.comment = property.comment;
                        propertyOption.columnType = property.columnType;
                        propertyOption.range = property.range;
                        if (!alterPropertyMap.containsKey(entity.tableName)) {
                            alterPropertyMap.put(entity.tableName, new ArrayList());
                        }
                        ((List)alterPropertyMap.get(entity.tableName)).add(propertyOption);
                    }
                }
            }
        }
        for (Map.Entry entry : alterPropertyMap.entrySet()) {
            for (PropertyOption propertyOption : (List)entry.getValue()) {
                flowContext.getQuickFlow().startFlow((BusinessFlow)new AlterTableColumnFlow()).putTemporaryData("tableName", entry.getKey()).putTemporaryData("propertyOption", (Object)propertyOption).execute();
            }
        }
    }

    public String name() {
        return "\u81ea\u52a8\u66f4\u65b0\u5b57\u6bb5";
    }

    private boolean shouldUpdate(Property property, Property databaseProperty) {
        if (property.id || null != property.strategy) {
            return false;
        }
        if (property.createdAt || property.updateAt) {
            return false;
        }
        if (null != property.comment && !property.comment.isEmpty() && !property.comment.equalsIgnoreCase(databaseProperty.comment)) {
            return true;
        }
        return null != property.notNull && !property.notNull.equals(databaseProperty.notNull);
    }
}

