/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.initial.flow.table;

import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.database.ddl.IndexField;
import cn.schoolwow.quickdao.domain.entity.Entity;
import cn.schoolwow.quickdao.domain.entity.Property;
import cn.schoolwow.quickdao.module.database.ddl.flow.column.CreateTableColumnFlow;
import cn.schoolwow.quickdao.module.database.ddl.flow.common.DeleteDatabaseEntityCacheFlow;
import cn.schoolwow.quickdao.module.database.ddl.flow.index.CreateIndexFlow;
import cn.schoolwow.quickdao.module.database.ddl.flow.table.CreateForeignKeyFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.domain.FlowDataFeature;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import java.util.List;

public class CompareAndCreateColumnFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        this.setDatabaseEntity(flowContext);
        this.createColumn(flowContext);
        this.createIndex(flowContext);
    }

    public String name() {
        return "\u6bd4\u8f83\u5e76\u521b\u5efa\u5b9e\u4f53\u7c7b\u5217";
    }

    private void setDatabaseEntity(FlowContext flowContext) {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkInstanceData(QuickDAOConfig.class);
        Entity entity = (Entity)flowContext.checkData("entity");
        Entity databaseEntity = quickDAOConfig.dao.getDatabaseEntity(entity.tableName);
        if (null == databaseEntity) {
            flowContext.brokenCurrentFlow("\u6570\u636e\u5e93\u8868\u4e0d\u5b58\u5728!\u8868\u540d:" + entity.tableName);
            return;
        }
        if (!databaseEntity.tableName.equalsIgnoreCase(entity.tableName)) {
            throw new IllegalArgumentException("\u5b9e\u4f53\u7c7b\u83b7\u53d6\u9519\u8bef!\u9884\u671f\u8868\u540d:" + entity.tableName + ",\u5b9e\u9645\u8868\u540d:" + databaseEntity.tableName);
        }
        flowContext.putCurrentFlowData("databaseEntity", (Object)databaseEntity, new FlowDataFeature[0]);
    }

    private void createColumn(FlowContext flowContext) {
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkInstanceData(QuickDAOConfig.class);
        Entity entity = (Entity)flowContext.checkData("entity");
        Entity databaseEntity = (Entity)flowContext.checkData("databaseEntity");
        List<Property> sourcePropertyList = entity.properties;
        for (Property sourceProperty : sourcePropertyList) {
            Property targetProperty = databaseEntity.getPropertyByFieldNameOrColumnName(sourceProperty.column);
            if (null == targetProperty) {
                flowContext.startFlow((BusinessFlow)new CreateTableColumnFlow()).next((BusinessFlow)new DeleteDatabaseEntityCacheFlow()).putData("tableName", (Object)databaseEntity.tableName, new FlowDataFeature[0]).putData("propertyOption", (Object)sourceProperty, new FlowDataFeature[0]).execute();
                targetProperty = databaseEntity.getPropertyByFieldNameOrColumnName(sourceProperty.column);
            }
            if (!quickDAOConfig.databaseOption.openForeignKey || null == sourceProperty.foreignKey || targetProperty.foreignKeyColumn) continue;
            flowContext.startFlow((BusinessFlow)new CreateForeignKeyFlow()).next((BusinessFlow)new DeleteDatabaseEntityCacheFlow()).putData("tableName", (Object)databaseEntity.tableName, new FlowDataFeature[0]).putData("propertyOption", (Object)sourceProperty, new FlowDataFeature[0]).execute();
        }
    }

    private void createIndex(FlowContext flowContext) {
        Entity entity = (Entity)flowContext.checkData("entity");
        Entity databaseEntity = (Entity)flowContext.checkData("databaseEntity");
        for (IndexField indexField : entity.indexFieldList) {
            boolean exist = false;
            for (IndexField databaseIndexField : databaseEntity.indexFieldList) {
                if (!databaseIndexField.indexName.equalsIgnoreCase(indexField.indexName)) continue;
                exist = true;
                break;
            }
            if (exist) continue;
            flowContext.startFlow((BusinessFlow)new CreateIndexFlow()).next((BusinessFlow)new DeleteDatabaseEntityCacheFlow()).putData("indexField", (Object)indexField, new FlowDataFeature[0]).putData("tableName", (Object)entity.tableName, new FlowDataFeature[0]).execute();
        }
    }
}

