/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickdao.module.operation.flow.generateEntity.single;

import cn.schoolwow.quickdao.annotation.IdStrategy;
import cn.schoolwow.quickdao.domain.QuickDAOConfig;
import cn.schoolwow.quickdao.domain.entity.Entity;
import cn.schoolwow.quickdao.domain.entity.Property;
import cn.schoolwow.quickdao.domain.operation.GenerateJavaSourceFileRequest;
import cn.schoolwow.quickdao.util.StringUtil;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.domain.FlowDataFeature;
import cn.schoolwow.quickflow.flow.BusinessFlow;

public class GenerateClassTablePropertyFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        Entity databaseEntity = (Entity)flowContext.checkData("databaseEntity");
        for (Property property : databaseEntity.properties) {
            flowContext.putCurrentFlowData("property", (Object)property, new FlowDataFeature[0]);
            this.generateComment(flowContext);
            this.generateIdStrategy(flowContext);
            this.generateColumnName(flowContext);
            this.generatePrivateField(flowContext);
        }
    }

    public String name() {
        return "\u751f\u6210\u5b9e\u4f53\u7c7b\u7684\u6210\u5458\u8868\u53d8\u91cf\u90e8\u5206";
    }

    private void generateComment(FlowContext flowContext) {
        Property property = (Property)flowContext.checkData("property");
        if (null == property.comment || property.comment.isEmpty()) {
            return;
        }
        StringBuilder builder = (StringBuilder)flowContext.checkData("builder");
        property.comment = property.comment.replaceAll("\r", "\\n").replaceAll("\n", "\\n").replaceAll("\r\n", "\\n");
        builder.append("\t@Comment(\"" + property.comment + "\")\n");
    }

    private void generateIdStrategy(FlowContext flowContext) {
        Property property = (Property)flowContext.checkData("property");
        if (null == property.comment || property.comment.isEmpty()) {
            return;
        }
        StringBuilder builder = (StringBuilder)flowContext.checkData("builder");
        if (property.id) {
            builder.append("\t@Id");
            if (!IdStrategy.AutoIncrement.equals((Object)property.strategy)) {
                builder.append("(strategy = IdStrategy.None)");
            }
            builder.append("\n");
        }
    }

    private void generateColumnName(FlowContext flowContext) {
        Property property = (Property)flowContext.checkData("property");
        StringBuilder builder = (StringBuilder)flowContext.checkData("builder");
        builder.append("\t@ColumnName(\"" + property.column + "\")\n");
        builder.append("\t@ColumnType(\"" + property.columnType + (null == property.range ? "" : "(" + property.range + ")") + "\")\n");
    }

    private void generatePrivateField(FlowContext flowContext) {
        GenerateJavaSourceFileRequest generateJavaSourceFileRequest = (GenerateJavaSourceFileRequest)flowContext.checkData("generateJavaSourceFileRequest");
        Property property = (Property)flowContext.checkData("property");
        StringBuilder builder = (StringBuilder)flowContext.checkData("builder");
        QuickDAOConfig quickDAOConfig = (QuickDAOConfig)flowContext.checkInstanceData(QuickDAOConfig.class);
        if (null != generateJavaSourceFileRequest.columnFieldTypeMapping) {
            property.className = generateJavaSourceFileRequest.columnFieldTypeMapping.apply(property.columnType);
        }
        if (null == property.className) {
            property.className = quickDAOConfig.databaseContext.databaseProvider.convertColumnTypeToJavaType(property.columnType);
        }
        if (null == property.className) {
            property.className = "{{" + property.columnType + "}}";
            System.out.println("\u65e0\u6cd5\u8f6c\u6362\u7684\u5217\u7c7b\u578b!" + property.columnType);
        }
        if (null == property.name || property.name.isEmpty()) {
            property.name = StringUtil.underline2Camel(property.column);
        }
        builder.append("\tprivate " + property.className + " " + property.name + ";\n\n");
    }
}

