/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.data.thread.config;

import cn.schoolwow.data.thread.listener.ProgressListener;
import cn.schoolwow.quickflow.QuickFlow;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;

public class QuickDataThreadConfig {
    private QuickFlow dataThreadFlow;

    public QuickDataThreadConfig(QuickFlow dataThreadFlow) {
        dataThreadFlow.putContextData("workDir", (Object)(System.getProperty("java.io.tmpdir") + File.separator + "QuickDataThread"));
        dataThreadFlow.putContextData("threadCount", (Object)(Runtime.getRuntime().availableProcessors() * 2));
        dataThreadFlow.putContextData("timeout", (Object)1);
        dataThreadFlow.putContextData("timeoutUnit", (Object)TimeUnit.HOURS);
        dataThreadFlow.putContextData("progressList", new ArrayList());
        dataThreadFlow.putContextData("waitFor", (Object)true);
        dataThreadFlow.putContextData("recordProgress", (Object)true);
        this.dataThreadFlow = dataThreadFlow;
    }

    public QuickDataThreadConfig workDir(String workDir) throws IOException {
        Files.createDirectories(Paths.get(workDir, new String[0]), new FileAttribute[0]);
        this.dataThreadFlow.putContextData("workDir", (Object)workDir);
        return this;
    }

    public QuickDataThreadConfig progressListener(ProgressListener progressListener) {
        this.dataThreadFlow.putContextData("progressListener", (Object)progressListener);
        return this;
    }

    public QuickDataThreadConfig threadCount(int threadCount) {
        this.dataThreadFlow.putContextData("threadCount", (Object)threadCount);
        return this;
    }

    public QuickDataThreadConfig timeout(Integer timeout, TimeUnit timeoutUnit) {
        this.dataThreadFlow.putContextData("timeout", (Object)timeout);
        this.dataThreadFlow.putContextData("timeoutUnit", (Object)timeoutUnit);
        return this;
    }

    public QuickDataThreadConfig waitFor(boolean waitFor) {
        this.dataThreadFlow.putContextData("waitFor", (Object)waitFor);
        return this;
    }

    public QuickDataThreadConfig recordProgress(boolean recordProgress) {
        this.dataThreadFlow.putContextData("recordProgress", (Object)recordProgress);
        return this;
    }
}

