/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickhttp;

import cn.schoolwow.quickhttp.connection.AbstractConnection;
import cn.schoolwow.quickhttp.connection.Connection;
import cn.schoolwow.quickhttp.util.Interceptor;
import cn.schoolwow.quickhttp.util.QuickHttpConfig;
import cn.schoolwow.quickhttp.util.ValidateUtil;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpCookie;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuickHttp {
    private static Logger logger = LoggerFactory.getLogger(QuickHttp.class);
    private static CookieManager cookieManager = new CookieManager();

    public static void intercept(Interceptor interceptor) {
        QuickHttpConfig.interceptor = interceptor;
    }

    public static void addCookie(String cookie, String url) {
        try {
            QuickHttp.addCookie(cookie, new URL(url));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public static void addCookie(String cookie, URL u) {
        String[] tokens;
        ValidateUtil.checkNotEmpty(cookie, "cookie\u4e0d\u80fd\u4e3a\u7a7a!");
        for (String token : tokens = cookie.split(";")) {
            int startIndex = token.indexOf("=");
            String name = token.substring(0, startIndex).trim();
            String value = token.substring(startIndex + 1).trim();
            QuickHttp.addCookie(name, value, u);
        }
    }

    public static void addCookie(String name, String value, String url) {
        try {
            QuickHttp.addCookie(name, value, new URL(url));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public static void addCookie(String name, String value, URL u) {
        ValidateUtil.checkNotNull(name, "name\u4e0d\u80fd\u4e3a\u7a7a!");
        ValidateUtil.checkNotNull(u, "URL\u4e0d\u80fd\u4e3a\u7a7a!");
        HttpCookie httpCookie = new HttpCookie(name, value);
        httpCookie.setMaxAge(3600000L);
        httpCookie.setDomain(QuickHttp.getTopHost(u.getHost()));
        httpCookie.setPath("/");
        httpCookie.setVersion(0);
        httpCookie.setDiscard(false);
        QuickHttp.addCookie(httpCookie);
    }

    public static void addCookie(HttpCookie httpCookie) {
        try {
            URI uri = new URI(httpCookie.getDomain());
            cookieManager.getCookieStore().add(uri, httpCookie);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public static void addCookie(List<HttpCookie> httpCookieList) {
        for (HttpCookie httpCookie : httpCookieList) {
            QuickHttp.addCookie(httpCookie);
        }
    }

    public static void addCookies(Map<String, String> cookies, String url) {
        try {
            QuickHttp.addCookies(cookies, new URL(url));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public static void addCookies(Map<String, String> cookies, URL u) {
        Set<String> keySet = cookies.keySet();
        for (String key : keySet) {
            QuickHttp.addCookie(key, cookies.get(key), u);
        }
    }

    public static HttpCookie getCookie(String url, String name) {
        ValidateUtil.checkNotEmpty(name, "name\u4e0d\u80fd\u4e3a\u7a7a!");
        List<HttpCookie> httpCookieList = QuickHttp.getCookies(url);
        for (HttpCookie httpCookie : httpCookieList) {
            if (!httpCookie.getName().equals(name)) continue;
            return httpCookie;
        }
        return null;
    }

    public static List<HttpCookie> getCookies(String url) {
        try {
            return QuickHttp.getCookies(new URL(url));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<HttpCookie> getCookies(URL u) {
        try {
            CookieManager cookieManager = (CookieManager)CookieHandler.getDefault();
            return cookieManager.getCookieStore().get(u.toURI());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void proxy(Proxy proxy) {
        ValidateUtil.checkNotNull(proxy, "\u4ee3\u7406\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a!");
        QuickHttpConfig.proxy = proxy;
        logger.info("[\u8bbe\u7f6e\u5168\u5c40\u4ee3\u7406]\u5730\u5740:{}", (Object)proxy.address());
    }

    public static void proxy(String host, int port) {
        ValidateUtil.checkNotEmpty(host, "\u4ee3\u7406\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a!");
        ValidateUtil.checkArgument(port > 0, "\u4ee3\u7406\u7aef\u53e3\u5fc5\u987b\u5927\u4e8e0!port:" + port);
        QuickHttpConfig.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port));
        logger.info("[\u8bbe\u7f6e\u5168\u5c40\u4ee3\u7406]\u5730\u5740:{},\u7aef\u53e3:{}", (Object)host, (Object)port);
    }

    public static void retryTimes(int retryTimes) {
        ValidateUtil.checkArgument(retryTimes > 0, "\u91cd\u8bd5\u6b21\u6570\u5fc5\u987b\u5927\u4e8e0!retryTimes:" + retryTimes);
        QuickHttpConfig.retryTimes = retryTimes;
        logger.info("[\u8bbe\u7f6e\u6700\u5927\u91cd\u8bd5\u6b21\u6570]\u6700\u5927\u91cd\u8bd5\u6b21\u6570:{}", (Object)retryTimes);
    }

    public static Connection connect(String url) {
        return AbstractConnection.getConnection(url);
    }

    private static String getTopHost(String host) {
        int startIndex;
        int endIndex = host.lastIndexOf(".");
        for (startIndex = endIndex - 1; startIndex > 0 && host.charAt(startIndex) != '.'; --startIndex) {
        }
        host = host.substring(startIndex);
        return host;
    }

    static {
        cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ORIGINAL_SERVER);
        CookieHandler.setDefault(cookieManager);
        System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
    }
}

