/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickhttp.connection;

import cn.schoolwow.quickhttp.QuickHttp;
import cn.schoolwow.quickhttp.connection.Connection;
import cn.schoolwow.quickhttp.response.AbstractResponse;
import cn.schoolwow.quickhttp.response.Response;
import cn.schoolwow.quickhttp.util.QuickHttpConfig;
import cn.schoolwow.quickhttp.util.ValidateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractConnection
implements Connection {
    private static Logger logger = LoggerFactory.getLogger(AbstractConnection.class);
    private static final char[] mimeBoundaryChars = "-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private static final int boundaryLength = 32;
    private static Map<String, String> historyMap = new HashMap<String, String>();
    private URL url;
    private Connection.Method method = Connection.Method.GET;
    protected Proxy proxy;
    private Map<String, String> headers = new HashMap<String, String>();
    private Map<String, String> dataMap = new HashMap<String, String>();
    private Map<String, File> dataFileMap = new HashMap<String, File>();
    private int timeout = 3000;
    private boolean followRedirects = true;
    private boolean ignoreHttpErrors = false;
    private String requestBody;
    private String charset = "utf-8";
    private String contentType = "application/x-www-form-urlencoded; charset=" + this.charset;
    private String userAgent;
    private int retryTimes;
    private int redirectTimes;
    private CookieManager cookieManager;
    private static SSLSocketFactory sslSocketFactory;
    private static HostnameVerifier hostnameVerifier;

    public static Connection getConnection(String url) {
        return new AbstractConnection(url);
    }

    private AbstractConnection(String url) {
        this.userAgent = Connection.UserAgent.CHROME.userAgent;
        this.retryTimes = -1;
        this.redirectTimes = 0;
        this.cookieManager = (CookieManager)CookieHandler.getDefault();
        this.url(url);
    }

    @Override
    public Connection url(URL url) {
        ValidateUtil.checkNotNull(url, "URL\u4e0d\u80fd\u4e3a\u7a7a!");
        this.url = url;
        return this;
    }

    @Override
    public Connection url(String url) {
        ValidateUtil.checkNotEmpty(url, "URL\u4e0d\u80fd\u4e3a\u7a7a!");
        try {
            this.url = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("URL\u4e0d\u5408\u6cd5!url:" + url, e);
        }
        return this;
    }

    @Override
    public Connection proxy(Proxy proxy) {
        ValidateUtil.checkNotNull(proxy, "\u4ee3\u7406\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a!");
        this.proxy = proxy;
        return this;
    }

    @Override
    public Connection proxy(String host, int port) {
        ValidateUtil.checkNotEmpty(host, "\u4ee3\u7406\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a!");
        ValidateUtil.checkArgument(port > 0, "\u4ee3\u7406\u7aef\u53e3\u5fc5\u987b\u5927\u4e8e0!port:" + port);
        this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port));
        return this;
    }

    @Override
    public Connection userAgent(String userAgent) {
        ValidateUtil.checkNotEmpty(userAgent, "\u7528\u6237\u4ee3\u7406\u4e0d\u80fd\u4e3a\u7a7a!");
        this.userAgent = userAgent;
        return this;
    }

    @Override
    public Connection userAgent(Connection.UserAgent userAgent) {
        ValidateUtil.checkNotNull((Object)userAgent, "\u7528\u6237\u4ee3\u7406\u4e0d\u80fd\u4e3a\u7a7a!");
        this.userAgent = userAgent.userAgent;
        return this;
    }

    @Override
    public Connection referrer(String referrer) {
        ValidateUtil.checkNotEmpty(referrer, "Referer\u503c\u4e0d\u80fd\u4e3a\u7a7a!");
        this.headers.put("Referer", referrer);
        return this;
    }

    @Override
    public Connection ajax() {
        return this.header("X-Requested-With", "XMLHttpRequest");
    }

    @Override
    public Connection timeout(int millis) {
        ValidateUtil.checkArgument(millis >= 0, "\u8d85\u65f6\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e0!millis:" + millis);
        this.timeout = millis;
        return this;
    }

    @Override
    public Connection followRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    @Override
    public Connection method(Connection.Method method) {
        ValidateUtil.checkNotNull((Object)method, "\u8bf7\u6c42\u65b9\u6cd5\u4e0d\u80fd\u4e3a\u7a7a!");
        this.method = method;
        return this;
    }

    @Override
    public Connection ignoreHttpErrors(boolean ignoreHttpErrors) {
        this.ignoreHttpErrors = ignoreHttpErrors;
        return this;
    }

    @Override
    public Connection sslSocketFactory(SSLSocketFactory sslSocketFactory) {
        ValidateUtil.checkNotNull((Object)this.method, "sslSocketFactory\u4e0d\u80fd\u4e3a\u7a7a!");
        AbstractConnection.sslSocketFactory = sslSocketFactory;
        return this;
    }

    @Override
    public Connection data(String key, String value) {
        this.dataMap.put(key, value);
        return this;
    }

    @Override
    public Connection data(String key, File file) {
        this.dataFileMap.put(key, file);
        return this;
    }

    @Override
    public Connection data(Map<String, String> data) {
        this.dataMap.putAll(data);
        return this;
    }

    @Override
    public Connection requestBody(String body) {
        this.requestBody = body;
        return this;
    }

    @Override
    public Connection requestBody(JSONObject body) {
        this.requestBody = body.toJSONString();
        this.contentType = "application/json; charset=" + this.charset;
        return this;
    }

    @Override
    public Connection requestBody(JSONArray array) {
        this.requestBody = array.toJSONString();
        this.contentType = "application/json; charset=" + this.charset;
        return this;
    }

    @Override
    public Connection header(String name, String value) {
        ValidateUtil.checkNotEmpty(name, "name\u4e0d\u80fd\u4e3a\u7a7a!");
        if (name.toLowerCase().equals("cookie")) {
            QuickHttp.addCookie(value, this.url);
        } else {
            this.headers.put(name, value);
        }
        return this;
    }

    @Override
    public Connection headers(Map<String, String> headers) {
        ValidateUtil.checkNotEmpty(headers, "headers\u4e0d\u80fd\u4e3a\u7a7a!");
        Set<String> keySet = headers.keySet();
        for (String key : keySet) {
            this.header(key, headers.get(key));
        }
        return this;
    }

    @Override
    public Connection cookie(String name, String value) {
        QuickHttp.addCookie(name, value, this.url);
        return this;
    }

    @Override
    public Connection cookie(HttpCookie httpCookie) {
        QuickHttp.addCookie(httpCookie);
        return this;
    }

    @Override
    public Connection cookie(List<HttpCookie> httpCookieList) {
        for (HttpCookie httpCookie : httpCookieList) {
            this.cookie(httpCookie);
        }
        return null;
    }

    @Override
    public Connection cookies(Map<String, String> cookies) {
        Set<String> keySet = cookies.keySet();
        for (String key : keySet) {
            this.cookie(key, cookies.get(key));
        }
        return this;
    }

    @Override
    public Connection charset(String charset) {
        this.charset = charset;
        return this;
    }

    @Override
    public Connection retryTimes(int retryTimes) {
        this.retryTimes = retryTimes;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Response execute() throws IOException {
        void var5_14;
        String referer;
        String protocol = this.url.getProtocol();
        ValidateUtil.checkArgument(protocol.matches("http(s)?"), "\u53ea\u652f\u6301http\u548chttps\u534f\u8bae.\u5f53\u524d\u534f\u8bae:" + protocol);
        StringBuilder parameterBuilder = new StringBuilder();
        if (!this.dataMap.isEmpty()) {
            Set<Map.Entry<String, String>> entrySet = this.dataMap.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                parameterBuilder.append(URLEncoder.encode(entry.getKey(), this.charset) + "=" + URLEncoder.encode(entry.getValue(), this.charset) + "&");
            }
            parameterBuilder.deleteCharAt(parameterBuilder.length() - 1);
        }
        if (!this.method.hasBody()) {
            String parameter = (this.url.getQuery() == null ? "" : this.url.getQuery()) + parameterBuilder.toString();
            if (parameter != null && !parameter.equals("")) {
                parameter = "?" + parameter;
            }
            this.url = new URL(this.url.getProtocol() + "://" + this.url.getAuthority() + this.url.getPath() + parameter);
        }
        if (this.proxy == null) {
            this.proxy = QuickHttpConfig.proxy;
        }
        HttpURLConnection httpURLConnection = (HttpURLConnection)(this.proxy == null ? this.url.openConnection() : this.url.openConnection(this.proxy));
        logger.info("[\u6253\u5f00\u94fe\u63a5]\u5730\u5740:{} {},\u4ee3\u7406:{}", new Object[]{this.method.name(), this.url, this.proxy == null ? "\u65e0" : this.proxy.address()});
        if (httpURLConnection instanceof HttpsURLConnection) {
            ((HttpsURLConnection)httpURLConnection).setSSLSocketFactory(sslSocketFactory);
            ((HttpsURLConnection)httpURLConnection).setHostnameVerifier(hostnameVerifier);
        }
        Set<Map.Entry<String, String>> entrySet = this.headers.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            httpURLConnection.setRequestProperty(entry.getKey(), entry.getValue());
            logger.debug("[\u8bbe\u7f6e\u5934\u90e8]name:{},value:{}", (Object)entry.getKey(), (Object)entry.getValue());
        }
        try {
            List<HttpCookie> httpCookieList = this.cookieManager.getCookieStore().get(this.url.toURI());
            for (HttpCookie httpCookie : httpCookieList) {
                logger.debug("[\u8bbe\u7f6eCookie]{}:{},{}", new Object[]{httpCookie.getName(), httpCookie.getValue(), JSON.toJSONString((Object)httpCookie)});
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        httpURLConnection.setRequestMethod(this.method.name());
        logger.debug("[\u8bbe\u7f6e\u8bf7\u6c42\u65b9\u6cd5]\u8bbe\u7f6eMethod:{}", (Object)this.method.name());
        httpURLConnection.setConnectTimeout(this.timeout);
        logger.debug("[\u8bbe\u7f6e\u8d85\u65f6\u65f6\u95f4]\u8bbe\u7f6e\u8d85\u65f6\u65f6\u95f4:{}", (Object)this.timeout);
        httpURLConnection.setReadTimeout(this.timeout / 2);
        httpURLConnection.setInstanceFollowRedirects(this.followRedirects);
        logger.debug("[\u8bbe\u7f6e\u91cd\u5b9a\u5411]\u662f\u5426\u81ea\u52a8\u91cd\u5b9a\u5411:{}", (Object)this.followRedirects);
        httpURLConnection.setRequestProperty("User-Agent", this.userAgent);
        logger.debug("[\u8bbe\u7f6e\u7528\u6237\u4ee3\u7406]UserAgent:{}", (Object)this.userAgent);
        httpURLConnection.setRequestProperty("Content-Type", this.contentType);
        logger.debug("[\u8bbe\u7f6e\u7c7b\u578b]Content-Type:{}", (Object)this.contentType);
        httpURLConnection.setRequestProperty("Accept-Encoding", "gzip, deflate");
        if (!(historyMap.isEmpty() || this.headers.containsKey("Referer") || (referer = historyMap.get(this.url.getHost())) == null || referer.equals(""))) {
            httpURLConnection.setRequestProperty("Referer", referer);
            logger.debug("[\u8bbe\u7f6eReferer]Referer:{}", (Object)referer);
        }
        if (QuickHttpConfig.interceptor != null) {
            QuickHttpConfig.interceptor.beforeConnect(this);
        }
        httpURLConnection.setDoInput(true);
        if (this.method.hasBody()) {
            String boundary = null;
            if (!this.dataFileMap.isEmpty()) {
                boundary = AbstractConnection.mimeBoundary();
                httpURLConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary + "; charset=" + this.charset);
                httpURLConnection.setChunkedStreamingMode(0);
            } else if (this.requestBody != null && !this.requestBody.equals("")) {
                httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=" + this.charset);
                httpURLConnection.setFixedLengthStreamingMode(this.requestBody.length());
            } else if (!this.dataMap.isEmpty()) {
                httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=" + this.charset);
                httpURLConnection.setFixedLengthStreamingMode(parameterBuilder.toString().length());
            }
            httpURLConnection.setDoOutput(true);
            OutputStream outputStream = httpURLConnection.getOutputStream();
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, this.charset));
            if (!this.dataFileMap.isEmpty()) {
                if (!this.dataMap.isEmpty()) {
                    Set<Map.Entry<String, String>> entrySet2 = this.dataMap.entrySet();
                    for (Map.Entry<String, Object> entry : entrySet2) {
                        bufferedWriter.write("--");
                        bufferedWriter.write(boundary);
                        bufferedWriter.write("\r\n");
                        bufferedWriter.write("Content-Disposition: form-data; name=\"" + entry.getKey().replaceAll("\"", "%22") + "\"\r\n");
                        bufferedWriter.write("\r\n");
                        bufferedWriter.write((String)entry.getValue());
                        bufferedWriter.write("\r\n");
                    }
                }
                Set<Map.Entry<String, File>> entrySet2 = this.dataFileMap.entrySet();
                for (Map.Entry<String, Object> entry : entrySet2) {
                    int len;
                    File file = (File)entry.getValue();
                    String name = entry.getKey().replaceAll("\"", "%22");
                    String fileName = file.getName().replaceAll("\"", "%22");
                    bufferedWriter.write("--");
                    bufferedWriter.write(boundary);
                    bufferedWriter.write("\r\n");
                    bufferedWriter.write("Content-Disposition: form-data; name=\"" + name + "\"; filename=\"" + fileName + "\"\r\n");
                    bufferedWriter.write("Content-Type: " + Files.probeContentType(Paths.get(file.getAbsolutePath(), new String[0])) + "\r\n");
                    bufferedWriter.write("\r\n");
                    bufferedWriter.flush();
                    FileInputStream fileInputStream = new FileInputStream(file);
                    byte[] buffer = new byte[32768];
                    while ((len = fileInputStream.read(buffer)) != -1) {
                        outputStream.write(buffer, 0, len);
                    }
                    outputStream.flush();
                    bufferedWriter.write("\r\n");
                }
                bufferedWriter.write("--");
                bufferedWriter.write(boundary);
                bufferedWriter.write("--");
            } else if (this.requestBody != null && !this.requestBody.equals("")) {
                bufferedWriter.write(this.requestBody);
            } else if (!this.dataMap.isEmpty()) {
                bufferedWriter.write(parameterBuilder.toString());
            }
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        int statusCode = httpURLConnection.getResponseCode();
        if (!(this.ignoreHttpErrors || statusCode >= 200 && statusCode < 400)) {
            throw new IOException("http\u72b6\u6001\u5f02\u5e38!statusCode:" + statusCode + ",\u8bbf\u95ee\u5730\u5740:" + this.url.toExternalForm());
        }
        AbstractResponse abstractResponse = new AbstractResponse(httpURLConnection, this.retryTimes);
        while (var5_14.statusCode() >= 300 && var5_14.statusCode() < 400 && var5_14.hasHeader("Location")) {
            if (this.redirectTimes >= QuickHttpConfig.maxRedirectTimes) {
                throw new IOException("\u91cd\u5b9a\u5411\u6b21\u6570\u8fc7\u591a!\u5f53\u524d\u6b21\u6570:" + this.redirectTimes + ",\u9650\u5236\u6700\u5927\u6b21\u6570:" + QuickHttpConfig.maxRedirectTimes);
            }
            this.url(var5_14.header("location"));
            ++this.redirectTimes;
            Response response = this.execute();
        }
        historyMap.put(this.url.getHost(), this.url.toString());
        if (QuickHttpConfig.interceptor != null) {
            QuickHttpConfig.interceptor.afterConnection(this, (Response)var5_14);
        }
        return var5_14;
    }

    @Override
    public void enqueue(Response.CallBack callBack) {
        ThreadPoolExecutorHolder.threadPoolExecutor.submit(() -> {
            try {
                Response response = this.execute();
                callBack.onResponse(response);
            }
            catch (IOException e) {
                e.printStackTrace();
                callBack.onError(this, e);
            }
        });
    }

    private static String mimeBoundary() {
        StringBuilder mime = new StringBuilder(32);
        Random rand = new Random();
        for (int i = 0; i < 32; ++i) {
            mime.append(mimeBoundaryChars[rand.nextInt(mimeBoundaryChars.length)]);
        }
        return mime.toString();
    }

    static {
        try {
            SSLContext sslcontext = SSLContext.getInstance("SSL", "SunJSSE");
            sslcontext.init(null, new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] ax509certificate, String s) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            }}, new SecureRandom());
            sslSocketFactory = sslcontext.getSocketFactory();
            hostnameVerifier = (s, sslSession) -> true;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("[\u521d\u59cb\u5316SSL\u4fe1\u606f\u5931\u8d25]\u4fe1\u606f:{}", (Object)e.getMessage());
        }
    }

    private static class ThreadPoolExecutorHolder {
        private static ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(QuickHttpConfig.corePoolSize, QuickHttpConfig.maximumPoolSize, 1L, TimeUnit.MINUTES, QuickHttpConfig.blockingQueue);

        private ThreadPoolExecutorHolder() {
        }
    }
}

