/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickhttp.document.parse;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeParser {
    private Logger logger = LoggerFactory.getLogger(AttributeParser.class);
    private char[] chars;
    private int pos = 0;
    private int sectionStart = 0;
    private State state;
    private Map<String, String> attributes = new HashMap<String, String>();
    private String currentKey;

    public static Map<String, String> parse(String attribute) {
        return new AttributeParser((String)attribute).attributes;
    }

    private AttributeParser(String attribute) {
        this.logger.trace("[\u89e3\u6790\u5c5e\u6027]{}", (Object)attribute);
        this.chars = attribute.toCharArray();
        this.parseAttribute();
    }

    private void parseAttribute() {
        this.state = this.chars[this.pos] == ' ' ? State.inSpace : State.inKey;
        ++this.pos;
        while (this.pos < this.chars.length) {
            switch (this.state) {
                case inSpace: {
                    if (this.isKeyValueStart()) {
                        if (this.isLastEqual()) {
                            this.state = State.inValue;
                            this.sectionStart = this.pos;
                            break;
                        }
                        if (this.currentKey != null) {
                            this.addAttribute(AttributeType.key);
                        }
                        this.state = State.inKey;
                        this.sectionStart = this.pos;
                        break;
                    }
                    if (this.chars[this.pos] == '=') {
                        this.state = State.inEqual;
                        break;
                    }
                    if (this.chars[this.pos] == '\'') {
                        this.state = State.inSingleQuoteStart;
                        this.sectionStart = this.pos;
                        break;
                    }
                    if (this.chars[this.pos] == '\"') {
                        this.state = State.inDoubleQuoteStart;
                        this.sectionStart = this.pos;
                        break;
                    }
                    if (this.pos != this.chars.length - 1) break;
                    this.addAttribute(AttributeType.key);
                    break;
                }
                case inKey: {
                    if (this.pos == this.chars.length - 1) {
                        this.currentKey = new String(this.chars, this.sectionStart, this.pos - this.sectionStart);
                        this.addAttribute(AttributeType.key);
                        break;
                    }
                    if (this.chars[this.pos] == ' ') {
                        this.currentKey = new String(this.chars, this.sectionStart, this.pos - this.sectionStart);
                        this.state = State.inSpace;
                        break;
                    }
                    if (this.chars[this.pos] != '=') break;
                    this.currentKey = new String(this.chars, this.sectionStart, this.pos - this.sectionStart);
                    this.state = State.inEqual;
                    break;
                }
                case inEqual: {
                    if (this.chars[this.pos] == ' ') {
                        this.state = State.inSpace;
                        break;
                    }
                    if (this.isKeyValueStart()) {
                        this.state = State.inValue;
                        this.sectionStart = this.pos;
                        break;
                    }
                    if (this.chars[this.pos] == '\'') {
                        this.state = State.inSingleQuoteStart;
                        this.sectionStart = this.pos;
                        break;
                    }
                    if (this.chars[this.pos] != '\"') break;
                    this.state = State.inDoubleQuoteStart;
                    this.sectionStart = this.pos;
                    break;
                }
                case inValue: {
                    if (this.chars[this.pos] != ' ' && this.pos != this.chars.length - 1) break;
                    this.state = State.inSpace;
                    this.addAttribute(AttributeType.keyValue);
                    break;
                }
                case inSingleQuoteStart: {
                    if (this.pos == this.chars.length - 1) {
                        this.addAttribute(AttributeType.quoteKeyValue);
                        break;
                    }
                    if (this.chars[this.pos] != '\'') break;
                    this.state = State.inSingleQuoteEnd;
                    break;
                }
                case inSingleQuoteEnd: {
                    if (this.pos == this.chars.length - 1) {
                        this.addAttribute(AttributeType.quoteKeyValue);
                        break;
                    }
                    if (this.chars[this.pos] != ' ') break;
                    this.state = State.inSpace;
                    this.addAttribute(AttributeType.quoteKeyValue);
                    break;
                }
                case inDoubleQuoteStart: {
                    if (this.pos == this.chars.length - 1) {
                        this.addAttribute(AttributeType.quoteKeyValue);
                        break;
                    }
                    if (this.chars[this.pos] != '\"') break;
                    this.state = State.inDoubleQuoteEnd;
                    break;
                }
                case inDoubleQuoteEnd: {
                    if (this.chars[this.pos - 1] == '\"') {
                        this.addAttribute(AttributeType.quoteKeyValue);
                    }
                    if (this.chars[this.pos] == ' ') {
                        this.state = State.inSpace;
                        break;
                    }
                    if (!this.isKeyValueStart()) break;
                    this.state = State.inKey;
                }
            }
            ++this.pos;
        }
        this.logger.trace("[\u5c5e\u6027\u5217\u8868]{}", (Object)JSON.toJSONString(this.attributes));
    }

    private void addAttribute(AttributeType attributeType) {
        String value;
        int count = this.pos - this.sectionStart;
        if (this.pos == this.chars.length - 1 && this.chars[this.pos] != ' ') {
            ++count;
        }
        if ((value = new String(this.chars, this.sectionStart, count)).charAt(value.length() - 1) == '=') {
            value = value.substring(0, value.length() - 1);
        }
        switch (attributeType) {
            case key: {
                this.attributes.put(value.trim(), "");
                break;
            }
            case keyValue: {
                this.attributes.put(this.currentKey.trim(), value);
                break;
            }
            case quoteKeyValue: {
                this.attributes.put(this.currentKey.trim(), value.substring(1, value.length() - 1));
            }
        }
        this.currentKey = null;
        this.sectionStart = this.pos;
    }

    private boolean isLastEqual() {
        int last;
        if (this.pos == 0) {
            return false;
        }
        for (last = this.pos - 1; last > 0 && this.chars[last] == ' '; --last) {
        }
        return this.chars[last] == '=';
    }

    private boolean isQuoteStartEnd() {
        return this.chars[this.pos] == '\"' || this.chars[this.pos] == '\'';
    }

    private boolean isKeyValueStart() {
        return this.chars[this.pos] == '_' || Character.isLetterOrDigit(this.chars[this.pos]);
    }

    private static enum State {
        inKey,
        inValue,
        inSingleQuoteStart,
        inDoubleQuoteStart,
        inSingleQuoteEnd,
        inDoubleQuoteEnd,
        inSpace,
        inEqual;

    }

    private static enum AttributeType {
        key,
        keyValue,
        quoteKeyValue;

    }
}

