/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickhttp.document.parse;

import cn.schoolwow.quickhttp.document.parse.HTMLToken;
import cn.schoolwow.quickhttp.util.ValidateUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTMLParser {
    private Logger logger = LoggerFactory.getLogger(HTMLParser.class);
    private static final String[] singleNodeList = new String[]{"br", "hr", "img", "input", "param", "meta", "link", "!doctype", "?xml", "col"};
    private char[] chars;
    private int pos = 0;
    private int sectionStart = 0;
    private boolean singleNode;
    private boolean isInStyleOrScript;
    private State state = State.openingTag;
    private List<HTMLToken> tokenList = new ArrayList<HTMLToken>();

    public static List<HTMLToken> parse(String html) {
        return new HTMLParser((String)html).tokenList;
    }

    private HTMLParser(String html) {
        this.chars = html.toCharArray();
        this.parseHTML();
    }

    private void parseHTML() {
        while (this.pos < this.chars.length) {
            switch (this.state) {
                case openingTag: {
                    if (this.isNextMatch("!--")) {
                        this.addToken(HTMLToken.TokenType.openTag);
                        this.state = State.inComment;
                        break;
                    }
                    if (this.pos <= 0 || this.chars[this.pos - 1] != '<') break;
                    this.addToken(HTMLToken.TokenType.openTag);
                    this.state = State.inTagName;
                    break;
                }
                case inTagName: {
                    String tagName;
                    if (this.chars[this.pos] == ' ') {
                        this.addToken(HTMLToken.TokenType.tagName);
                        tagName = this.tokenList.get((int)(this.tokenList.size() - 1)).value.toLowerCase();
                        this.singleNode = HTMLParser.isSingleNode(tagName);
                        this.state = State.inAttribute;
                        break;
                    }
                    if (this.chars[this.pos] == '>') {
                        this.addToken(HTMLToken.TokenType.tagName);
                        tagName = this.tokenList.get((int)(this.tokenList.size() - 1)).value.toLowerCase();
                        if (HTMLParser.isSingleNode(tagName)) {
                            this.singleNode = true;
                            this.state = State.closingTag;
                            break;
                        }
                        this.singleNode = false;
                        this.state = State.openTagClosing;
                        break;
                    }
                    if (!this.isNextMatch("/>")) break;
                    this.addToken(HTMLToken.TokenType.tagName);
                    this.state = State.closingTag;
                    break;
                }
                case inComment: {
                    if (this.chars[this.pos] != '>' || this.chars[this.pos - 1] != '-' || this.chars[this.pos - 2] != '-') break;
                    this.addToken(HTMLToken.TokenType.commentTag);
                    this.singleNode = true;
                    this.state = State.closingTag;
                    break;
                }
                case inAttribute: {
                    if (this.chars[this.pos] == '>' || this.isNextMatch("?>")) {
                        this.addToken(HTMLToken.TokenType.attribute);
                        if (this.chars[this.pos] == '>' && this.pos == this.chars.length - 1 || this.chars[this.pos] == '?' && this.pos == this.chars.length - 2) {
                            this.sectionStart = this.pos;
                            this.addToken(HTMLToken.TokenType.closeTag);
                        }
                        this.state = this.singleNode ? State.closingTag : State.openTagClosing;
                        break;
                    }
                    if (this.chars[this.pos] == '\'') {
                        this.state = State.inAttributeSingleQuote;
                        break;
                    }
                    if (this.chars[this.pos] == '\"') {
                        this.state = State.inAttributeDoubleQuote;
                        break;
                    }
                    if (!this.isNextMatch("/>")) break;
                    this.addToken(HTMLToken.TokenType.attribute);
                    this.state = State.closingTag;
                    break;
                }
                case inAttributeSingleQuote: {
                    if (this.chars[this.pos] != '\'') break;
                    this.state = State.inAttribute;
                    break;
                }
                case inAttributeDoubleQuote: {
                    if (this.chars[this.pos] != '\"') break;
                    this.state = State.inAttribute;
                    break;
                }
                case openTagClosing: {
                    if (this.chars[this.pos - 1] == '>' && this.chars[this.pos] != '<') {
                        this.addToken(HTMLToken.TokenType.openTagClose);
                        this.state = State.inTextContent;
                        break;
                    }
                    if (this.isNextMatch("</")) {
                        this.addToken(HTMLToken.TokenType.openTagClose);
                        this.state = State.closingTag;
                        break;
                    }
                    if (this.chars[this.pos] != '<') break;
                    this.addToken(HTMLToken.TokenType.openTagClose);
                    this.state = State.openingTag;
                    break;
                }
                case inTextContent: {
                    if (this.isInStyleOrScript) {
                        if (!this.isNextMatch("</script>") && !this.isNextMatch("</style>")) break;
                        this.addToken(HTMLToken.TokenType.textContent);
                        this.isInStyleOrScript = false;
                        this.state = State.closingTag;
                        break;
                    }
                    if (this.isNextMatch("</")) {
                        this.addToken(HTMLToken.TokenType.textContent);
                        this.state = State.closingTag;
                        break;
                    }
                    if (this.chars[this.pos] != '<') break;
                    this.addToken(HTMLToken.TokenType.textContent);
                    this.state = State.openingTag;
                    break;
                }
                case closingTag: {
                    if (this.chars[this.pos - 1] == '>' && this.isNextMatch("</")) {
                        this.addToken(HTMLToken.TokenType.closeTag);
                        break;
                    }
                    if (this.chars[this.pos - 1] == '>' && this.chars[this.pos] == '<') {
                        this.addToken(HTMLToken.TokenType.closeTag);
                        this.state = State.openingTag;
                        break;
                    }
                    if (this.pos == this.chars.length - 1) {
                        this.addToken(HTMLToken.TokenType.closeTag);
                        break;
                    }
                    if (this.chars[this.pos - 1] != '>') break;
                    this.addToken(HTMLToken.TokenType.closeTag);
                    this.state = State.inTextContent;
                }
            }
            ++this.pos;
        }
        this.logger.trace("[Token\u5217\u8868]{}", (Object)this.tokenList.toString());
    }

    private void addToken(HTMLToken.TokenType tokenType) {
        HTMLToken token = new HTMLToken();
        token.start = this.sectionStart;
        token.end = this.pos;
        token.tokenType = tokenType;
        if (this.pos == this.sectionStart) {
            token.value = this.chars[this.pos] + "";
        } else {
            int count = token.end - token.start;
            if (this.pos == this.chars.length - 1) {
                ++count;
            }
            token.value = new String(this.chars, token.start, count);
        }
        if (tokenType.equals((Object)HTMLToken.TokenType.tagName) && (token.value.equals("script") || token.value.equals("style"))) {
            this.isInStyleOrScript = true;
        }
        if (tokenType.equals((Object)HTMLToken.TokenType.closeTag) && (token.value.contains("script") || token.value.contains("style"))) {
            this.isInStyleOrScript = false;
        }
        this.sectionStart = this.pos;
        this.tokenList.add(token);
    }

    private boolean isNextMatch(String key) {
        int index;
        ValidateUtil.checkNotEmpty(key);
        int last = this.pos;
        for (index = 0; last < this.chars.length && index < key.length() && this.chars[last] == key.charAt(index); ++last, ++index) {
        }
        return index == key.length();
    }

    private static boolean isSingleNode(String tagName) {
        for (String singleNode : singleNodeList) {
            if (!tagName.equals(singleNode)) continue;
            return true;
        }
        return false;
    }

    private static enum State {
        openingTag,
        inTagName,
        inAttribute,
        inAttributeSingleQuote,
        inAttributeDoubleQuote,
        openTagClosing,
        inTextContent,
        closingTag,
        inComment;

    }
}

