/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickhttp.document.parse;

import cn.schoolwow.quickhttp.document.element.Element;
import cn.schoolwow.quickhttp.document.element.Elements;
import cn.schoolwow.quickhttp.document.parse.AttributeParser;
import cn.schoolwow.quickhttp.document.parse.HTMLToken;
import cn.schoolwow.quickhttp.document.query.Evaluator;
import cn.schoolwow.quickhttp.document.query.QueryParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTMLTokenParser {
    private Logger logger = LoggerFactory.getLogger(HTMLTokenParser.class);
    private List<HTMLToken> htmlTokenList;
    private AbstractElement root = null;
    private List<AbstractElement> allElements = new ArrayList<AbstractElement>();

    public static Element parse(List<HTMLToken> htmlTokenList) {
        AbstractElement root = new HTMLTokenParser(htmlTokenList).root;
        return root;
    }

    private HTMLTokenParser(List<HTMLToken> htmlTokenList) {
        this.htmlTokenList = htmlTokenList;
        this.parse();
    }

    private void parse() {
        AbstractElement current = this.root;
        for (HTMLToken htmlToken : this.htmlTokenList) {
            switch (htmlToken.tokenType) {
                case openTag: {
                    AbstractElement newElement = new AbstractElement();
                    this.allElements.add(newElement);
                    if (current == null) {
                        this.root = newElement;
                    } else {
                        newElement.parent = current;
                        newElement.parent.childList.add(newElement);
                        newElement.parent.childTextList.add(newElement);
                    }
                    current = newElement;
                    break;
                }
                case tagName: {
                    current.tagName = htmlToken.value.toLowerCase();
                    break;
                }
                case commentTag: {
                    current.isComment = true;
                    current.ownOriginText = htmlToken.value;
                    current.ownText = this.escapeOwnOriginText(current.ownOriginText);
                    break;
                }
                case attribute: {
                    current.attribute = htmlToken.value;
                    if ("!DOCTYPE".equals(current.tagName.toUpperCase())) break;
                    current.attributes.putAll(AttributeParser.parse(htmlToken.value));
                    break;
                }
                case openTagClose: {
                    break;
                }
                case textContent: {
                    if (current == null) break;
                    AbstractElement textElement = new AbstractElement();
                    textElement.isTextNode = true;
                    textElement.ownOriginText = htmlToken.value;
                    textElement.ownText = this.escapeOwnOriginText(htmlToken.value);
                    textElement.parent = current;
                    textElement.outerHtml = textElement.ownText;
                    textElement.textContent = textElement.ownText;
                    current.childTextList.add(textElement);
                    current.textList.add(textElement);
                    break;
                }
                case closeTag: {
                    if (htmlToken.value.equals(">") || htmlToken.value.equals("/>")) {
                        current.isSingleNode = true;
                        current = current.parent;
                        break;
                    }
                    if (!("</" + current.tagName + ">").equals(htmlToken.value)) break;
                    current = current.parent;
                }
            }
        }
        for (AbstractElement element : this.allElements) {
            if (element.isComment) continue;
            StringBuilder ownTextBuilder = new StringBuilder("");
            StringBuilder originTextBuilder = new StringBuilder("");
            for (Element e : element.textList) {
                AbstractElement ee = (AbstractElement)e;
                ownTextBuilder.append(ee.ownText);
                originTextBuilder.append(ee.ownOriginText);
            }
            element.ownText = ownTextBuilder.toString();
            element.ownOriginText = originTextBuilder.toString();
            element.assureAllElements();
        }
    }

    private String escapeOwnOriginText(String ownOriginText) {
        return ownOriginText.replace("&quot;", "\"").replace("&amp;", "&").replace("&lt;", "<").replace("&gt;", ">").replace("&nbsp;", " ");
    }

    class AbstractElement
    implements Element {
        private String tagName;
        private boolean isSingleNode;
        private boolean isComment;
        private boolean isTextNode;
        private AbstractElement parent;
        private Map<String, String> attributes = new HashMap<String, String>();
        private String attribute = "";
        private String ownOriginText = "";
        private String ownText = "";
        private List<Element> childList = new ArrayList<Element>();
        private Elements textList = new Elements();
        private List<Element> childTextList = new ArrayList<Element>();
        private Elements childTextElements;
        private Elements childElements;
        private Elements textElements;
        private String textContent;
        private String outerHtml;
        private String html;
        private int elementSiblingpos = -1;

        AbstractElement() {
        }

        @Override
        public Elements select(String cssQuery) {
            Elements elements = new Elements();
            Evaluator evaluator = QueryParser.parse(cssQuery);
            LinkedList<Element> linkedList = new LinkedList<Element>();
            linkedList.offer(this);
            while (!linkedList.isEmpty()) {
                Element element = (Element)linkedList.poll();
                if (element.tagName() == null) continue;
                if (evaluator.matches(element)) {
                    elements.add(element);
                }
                linkedList.addAll(element.childElements());
            }
            return elements;
        }

        @Override
        public Element selectFirst(String cssQuery) {
            return this.select(cssQuery).first();
        }

        @Override
        public Element selectLast(String cssQuery) {
            return this.select(cssQuery).last();
        }

        @Override
        public Map<String, String> attribute() {
            return this.attributes;
        }

        @Override
        public String id() {
            return this.attributes.get("id");
        }

        @Override
        public boolean hasClass(String className) {
            String elementClassName = this.attributes.get("class");
            if (elementClassName == null || elementClassName.isEmpty()) {
                return false;
            }
            String[] classNames = new String[]{className};
            if (className.contains(".")) {
                classNames = className.split("\\.");
            }
            for (String _className : classNames) {
                if (elementClassName.contains(_className)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean hasAttr(String attributeKey) {
            return this.attributes.containsKey(attributeKey);
        }

        @Override
        public String attr(String attributeKey) {
            return this.attributes.get(attributeKey);
        }

        @Override
        public String tagName() {
            return this.tagName;
        }

        @Override
        public String text() {
            if (this.textContent != null) {
                return this.textContent;
            }
            StringBuilder builder = new StringBuilder();
            for (Element element : this.textElements) {
                builder.append(element.ownText());
            }
            this.textContent = builder.toString();
            return this.textContent;
        }

        @Override
        public Elements textElement() {
            return this.textList;
        }

        @Override
        public String html() {
            if (this.html == null) {
                this.html = this.iterateChildTextElements(this.childTextElements.subList(1, this.childTextElements.size() - 1));
            }
            return this.html;
        }

        @Override
        public String ownText() {
            return this.ownText;
        }

        @Override
        public String outerHtml() {
            if (this.outerHtml == null) {
                this.outerHtml = this.iterateChildTextElements(this.childTextElements);
            }
            return this.outerHtml;
        }

        @Override
        public String val() {
            if ("textarea".equals(this.tagName)) {
                return this.text();
            }
            if (this.hasAttr("value")) {
                return this.attr("value");
            }
            return null;
        }

        @Override
        public Element parent() {
            return this.parent;
        }

        @Override
        public Element firstChild() {
            if (this.childList.isEmpty()) {
                return null;
            }
            return this.childList.get(0);
        }

        @Override
        public Element lastChild() {
            if (this.childList.isEmpty()) {
                return null;
            }
            return this.childList.get(this.childList.size() - 1);
        }

        @Override
        public Element childElement(int index) {
            if (index < 1 || index > this.childList.size()) {
                return null;
            }
            return this.childList.get(index - 1);
        }

        @Override
        public Elements childElements() {
            return new Elements(this.childList);
        }

        @Override
        public Elements siblingElements() {
            Elements elements = new Elements();
            for (Element element : this.parent.childList) {
                if (element == this) continue;
                elements.add(element);
            }
            return elements;
        }

        @Override
        public Element previousElementSibling() {
            int pos = this.elementSiblingIndex();
            if (pos - 1 >= 0) {
                return this.parent.childList.get(pos - 1);
            }
            return null;
        }

        @Override
        public Element nextElementSibling() {
            int pos = this.elementSiblingIndex();
            if (pos + 1 < this.parent.childList.size()) {
                return this.parent.childList.get(pos + 1);
            }
            return null;
        }

        @Override
        public int elementSiblingIndex() {
            if (this.elementSiblingpos >= 0) {
                return this.elementSiblingpos;
            }
            if (this.parent == null) {
                this.elementSiblingpos = 0;
                return this.elementSiblingpos;
            }
            for (int i = 0; i < this.parent.childList.size(); ++i) {
                if (this.parent.childList.get(i) != this) continue;
                this.elementSiblingpos = i;
                return this.elementSiblingpos;
            }
            this.elementSiblingpos = 0;
            return this.elementSiblingpos;
        }

        @Override
        public Elements getAllElements() {
            return this.childElements;
        }

        public String toString() {
            if (this.isComment) {
                return "<" + this.ownText + ">";
            }
            if (this.isSingleNode) {
                return "<" + this.tagName + this.attribute + "/>";
            }
            return "<" + this.tagName + this.attribute + ">" + this.ownOriginText.replaceAll("\r\n", "\u6362\u884c\u7b26") + "</" + this.tagName + ">";
        }

        private String iterateChildTextElements(List<Element> childTextElements) {
            StringBuilder builder = new StringBuilder();
            Stack<AbstractElement> stack = new Stack<AbstractElement>();
            for (int i = 0; i < childTextElements.size(); ++i) {
                AbstractElement abstractElement = (AbstractElement)childTextElements.get(i);
                while (!stack.isEmpty() && abstractElement.parent != null && stack.peek() != abstractElement.parent) {
                    builder.append("</" + ((AbstractElement)stack.pop()).tagName + ">");
                }
                if (abstractElement.isComment) {
                    builder.append("<" + abstractElement.ownOriginText + ">");
                    continue;
                }
                if (abstractElement.isTextNode) {
                    builder.append(abstractElement.ownOriginText);
                    continue;
                }
                if (abstractElement.isSingleNode) {
                    builder.append("<" + abstractElement.tagName + abstractElement.attribute);
                    if (!abstractElement.tagName.startsWith("!") && !abstractElement.tagName.startsWith("?")) {
                        builder.append("/");
                    }
                    builder.append(">");
                    continue;
                }
                builder.append("<" + abstractElement.tagName + abstractElement.attribute + ">");
                if (abstractElement.childTextList.size() == 0) {
                    builder.append("</" + abstractElement.tagName + ">");
                    continue;
                }
                stack.push(abstractElement);
            }
            while (!stack.isEmpty()) {
                AbstractElement element = (AbstractElement)stack.pop();
                if (element.isSingleNode) {
                    builder.append("/>");
                    continue;
                }
                builder.append("</" + element.tagName + ">");
            }
            return builder.toString();
        }

        private void assureAllElements() {
            this.childTextElements = new Elements();
            this.textElements = new Elements();
            this.childElements = new Elements();
            Stack<AbstractElement> stack = new Stack<AbstractElement>();
            stack.push(this);
            while (!stack.isEmpty()) {
                AbstractElement element = (AbstractElement)stack.pop();
                this.childTextElements.add(element);
                if (element.isTextNode) {
                    this.textElements.add(element);
                } else {
                    this.childElements.add(element);
                }
                List<Element> childElements = element.childTextList;
                for (int i = childElements.size() - 1; i >= 0; --i) {
                    stack.push((AbstractElement)childElements.get(i));
                }
            }
        }
    }
}

