/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickhttp.document.query;

import cn.schoolwow.quickhttp.document.query.CombiningEvaluator;
import cn.schoolwow.quickhttp.document.query.Evaluator;
import cn.schoolwow.quickhttp.document.query.StructuralEvaluator;
import cn.schoolwow.quickhttp.util.ValidateUtil;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryParser {
    private static Logger logger = LoggerFactory.getLogger(QueryParser.class);
    private static final char[] combinators = new char[]{'>', '+', '~', ' '};
    private static final Map<String, Evaluator> pseudoMap = new HashMap<String, Evaluator>();
    private char[] chars;
    private int pos;
    private Evaluator root;
    private static final Stack<Evaluator> evaluatorStack;
    private static CombiningEvaluator.Or or;

    public static Evaluator parse(String cssQuery) {
        or = null;
        return new QueryParser((String)cssQuery).root;
    }

    private QueryParser(String cssQuery) {
        evaluatorStack.clear();
        this.chars = cssQuery.toCharArray();
        Selector[] selectors = Selector.values();
        while (this.pos < this.chars.length) {
            boolean find = false;
            for (Selector selector : selectors) {
                int count = (Integer)selector.condition.apply(this.chars, this.pos);
                if (count <= 0) continue;
                this.pos += count;
                find = true;
                break;
            }
            if (find) continue;
            ++this.pos;
        }
        if (!evaluatorStack.isEmpty()) {
            CombiningEvaluator.And lastAnd = new CombiningEvaluator.And(new ArrayList<Evaluator>());
            while (!evaluatorStack.isEmpty() && !(evaluatorStack.peek() instanceof StructuralEvaluator)) {
                lastAnd.evaluatorList.add(evaluatorStack.pop());
            }
            evaluatorStack.push(lastAnd);
        }
        logger.trace("[\u539f\u59cb\u9009\u62e9\u5668\u5217\u8868]{}", evaluatorStack);
        if (or != null) {
            CombiningEvaluator.And and = new CombiningEvaluator.And(new ArrayList<Evaluator>());
            while (!evaluatorStack.isEmpty()) {
                and.evaluatorList.add(evaluatorStack.pop());
            }
            if (and.evaluatorList.size() == 1) {
                QueryParser.or.evaluatorList.add(and.evaluatorList.get(0));
            } else {
                QueryParser.or.evaluatorList.add(and);
            }
        }
        if (or != null) {
            this.root = or;
        } else if (evaluatorStack.size() == 1) {
            this.root = (Evaluator)evaluatorStack.get(0);
        } else {
            ArrayList<Evaluator> evaluatorList = new ArrayList<Evaluator>(evaluatorStack.size());
            while (!evaluatorStack.isEmpty()) {
                evaluatorList.add(evaluatorStack.pop());
            }
            this.root = new CombiningEvaluator.And(evaluatorList);
        }
        logger.trace("[\u6700\u7ec8\u9009\u62e9\u5668\u5217\u8868]{}", (Object)this.root);
    }

    private static boolean isCombinators(char c) {
        for (char combinator : combinators) {
            if (c != combinator) continue;
            return true;
        }
        return false;
    }

    static {
        pseudoMap.put(":first-child", new Evaluator.IsFirstChild());
        pseudoMap.put(":last-child", new Evaluator.IsLastChild());
        pseudoMap.put(":first-of-type", new Evaluator.IsFirstOfType());
        pseudoMap.put(":last-of-type", new Evaluator.IsLastOfType());
        pseudoMap.put(":only-child", new Evaluator.IsOnlyChild());
        pseudoMap.put(":only-of-type", new Evaluator.IsOnlyOfType());
        pseudoMap.put(":empty", new Evaluator.IsEmpty());
        evaluatorStack = new Stack();
    }

    private static enum Selector {
        ByIdOrClass((chars, pos) -> {
            int last;
            if (chars[pos] != '#' && chars[pos] != '.') {
                return 0;
            }
            for (last = pos.intValue(); last < ((char[])chars).length - 1 && !QueryParser.isCombinators(chars[last]); ++last) {
            }
            int count = last - pos;
            if (last == ((char[])chars).length - 1) {
                ++count;
            }
            String content = new String((char[])chars, (int)pos, count);
            if (chars[pos] == '#') {
                Evaluator.Id idEvaluator = new Evaluator.Id(content.substring(1));
                evaluatorStack.push(idEvaluator);
                logger.trace("[\u6dfb\u52a0id\u9009\u62e9\u5668]{}", (Object)idEvaluator);
            } else if (chars[pos] == '.') {
                Evaluator.Class aClassEvaluator = new Evaluator.Class(content.substring(1));
                evaluatorStack.push(aClassEvaluator);
                logger.trace("[\u6dfb\u52a0class\u9009\u62e9\u5668]{}", (Object)aClassEvaluator);
            }
            return content.length();
        }),
        ByTag((chars, pos) -> {
            int last;
            if (!Character.isLetterOrDigit(chars[pos])) {
                return 0;
            }
            for (last = pos.intValue(); last < ((char[])chars).length - 1 && Character.isLetterOrDigit(chars[last]); ++last) {
            }
            int count = last - pos;
            if (last == ((char[])chars).length - 1) {
                ++count;
            }
            String content = new String((char[])chars, (int)pos, count);
            Evaluator.Tag tag = new Evaluator.Tag(content);
            evaluatorStack.push(tag);
            logger.trace("[\u6dfb\u52a0tag\u9009\u62e9\u5668]{}", (Object)tag);
            return content.length();
        }),
        ByAll((chars, pos) -> {
            if (chars[pos] != '*') {
                return 0;
            }
            evaluatorStack.push(new Evaluator.AllElements());
            return 1;
        }),
        ByAttribute((chars, pos) -> {
            int last;
            if (chars[pos] != '[') {
                return 0;
            }
            for (last = pos.intValue(); last < ((char[])chars).length - 1 && chars[last] != ']'; ++last) {
            }
            ValidateUtil.checkArgument(chars[last] == ']', "\u4e0d\u5408\u6cd5\u7684\u5c5e\u6027\u9009\u62e9\u5668! pos:" + pos);
            int count = last - pos + 1;
            String content = new String((char[])chars, (int)pos, count);
            String escapeContent = content.substring(1, content.length() - 1).replaceAll("[\"|']]", "");
            Evaluator evaluator = null;
            if (content.charAt(1) == '^') {
                evaluator = new Evaluator.AttributeStarting(content.substring(2, content.length() - 1));
            } else if (content.contains("^=")) {
                String[] tokens = escapeContent.split("\\^=");
                ValidateUtil.checkArgument(tokens.length == 2, "\u5206\u5272\u5c5e\u6027\u5b57\u7b26\u4e32\u5931\u8d25!tokens:" + JSON.toJSONString((Object)tokens));
                evaluator = new Evaluator.AttributeWithValueStarting(tokens[0], tokens[1]);
            } else if (content.contains("$=")) {
                String[] tokens = escapeContent.split("\\$=");
                ValidateUtil.checkArgument(tokens.length == 2, "\u5206\u5272\u5c5e\u6027\u5b57\u7b26\u4e32\u5931\u8d25!tokens:" + JSON.toJSONString((Object)tokens));
                evaluator = new Evaluator.AttributeWithValueEnding(tokens[0], tokens[1]);
            } else if (content.contains("*=")) {
                String[] tokens = escapeContent.split("\\*=");
                ValidateUtil.checkArgument(tokens.length == 2, "\u5206\u5272\u5c5e\u6027\u5b57\u7b26\u4e32\u5931\u8d25!tokens:" + JSON.toJSONString((Object)tokens));
                evaluator = new Evaluator.AttributeWithValueContaining(tokens[0], tokens[1]);
            } else if (content.contains("~=")) {
                String[] tokens = escapeContent.split("\\~=");
                ValidateUtil.checkArgument(tokens.length == 2, "\u5206\u5272\u5c5e\u6027\u5b57\u7b26\u4e32\u5931\u8d25!tokens:" + JSON.toJSONString((Object)tokens));
                evaluator = new Evaluator.AttributeWithValueMatching(tokens[0], Pattern.compile(tokens[1]));
            } else if (content.contains("=")) {
                String[] tokens = escapeContent.split("=");
                ValidateUtil.checkArgument(tokens.length == 2, "\u5206\u5272\u5c5e\u6027\u5b57\u7b26\u4e32\u5931\u8d25!tokens:" + JSON.toJSONString((Object)tokens));
                evaluator = new Evaluator.AttributeWithValue(tokens[0], tokens[1]);
            } else {
                evaluator = new Evaluator.Attribute(content.substring(1, content.length() - 1));
            }
            evaluatorStack.push(evaluator);
            logger.trace("[\u6dfb\u52a0{}\u9009\u62e9\u5668]{}", (Object)evaluator.getClass().getSimpleName(), (Object)evaluator);
            return content.length();
        }),
        ByOr((chars, pos) -> {
            int last;
            if (chars[pos] != ' ' && chars[pos] != ',') {
                return 0;
            }
            for (last = pos.intValue(); last < ((char[])chars).length - 1 && (chars[last] == ' ' || chars[last] == ','); ++last) {
            }
            String content = new String((char[])chars, (int)pos, last - pos);
            if (!content.contains(",")) {
                return 0;
            }
            CombiningEvaluator.And and = new CombiningEvaluator.And(new ArrayList<Evaluator>());
            while (!evaluatorStack.isEmpty() && !(evaluatorStack.peek() instanceof CombiningEvaluator.And)) {
                and.evaluatorList.add(evaluatorStack.pop());
            }
            if (or == null) {
                or = new CombiningEvaluator.Or(new ArrayList<Evaluator>());
                logger.trace("[\u6dfb\u52a0Or\u9009\u62e9\u5668]{}", (Object)or);
            }
            if (and.evaluatorList.size() == 1) {
                or.evaluatorList.add(and.evaluatorList.get(0));
            } else {
                or.evaluatorList.add(and);
            }
            logger.trace("[Or\u9009\u62e9\u5668\u4e2d\u6dfb\u52a0And\u9009\u62e9\u5668]{}", (Object)and);
            return content.length();
        }),
        ByCombination((chars, pos) -> {
            int last;
            if (!QueryParser.isCombinators(chars[pos])) {
                return 0;
            }
            for (last = pos.intValue(); last < ((char[])chars).length - 1 && QueryParser.isCombinators(chars[last]); ++last) {
            }
            String content = new String((char[])chars, (int)pos, last - pos);
            ArrayList<Evaluator> evaluatorList = new ArrayList<Evaluator>();
            while (!evaluatorStack.isEmpty() && !(evaluatorStack.peek() instanceof StructuralEvaluator)) {
                evaluatorList.add((Evaluator)evaluatorStack.pop());
            }
            Evaluator lastEvaluator = null;
            lastEvaluator = evaluatorList.size() == 1 ? (Evaluator)evaluatorList.get(0) : new CombiningEvaluator.And(evaluatorList);
            if (!evaluatorStack.isEmpty()) {
                CombiningEvaluator.And and = new CombiningEvaluator.And(new ArrayList<Evaluator>());
                and.evaluatorList.add(lastEvaluator);
                and.evaluatorList.add(evaluatorStack.pop());
                lastEvaluator = and;
            }
            StructuralEvaluator evaluator = null;
            if (content.contains(">")) {
                evaluator = new StructuralEvaluator.ImmediateParent(lastEvaluator);
            } else if (content.contains("+")) {
                evaluator = new StructuralEvaluator.ImmediatePreviousSibling(lastEvaluator);
            } else if (content.contains("~")) {
                evaluator = new StructuralEvaluator.PreviousSibling(lastEvaluator);
            } else if (content.contains(" ")) {
                evaluator = new StructuralEvaluator.Parent(lastEvaluator);
            }
            ValidateUtil.checkNotNull(lastEvaluator, "\u4e0d\u5408\u6cd5\u7684\u89e3\u6790\u5668!value:" + content);
            evaluatorStack.push(evaluator);
            logger.trace("[\u6dfb\u52a0Combination\u9009\u62e9\u5668]{}", (Object)evaluator);
            return content.length();
        }),
        ByPseudoCommon((chars, pos) -> {
            int count = ":first-of-type".length();
            if (pos + count >= ((char[])chars).length) {
                count = ((char[])chars).length - pos;
            }
            String prefix = new String((char[])chars, (int)pos, count);
            Set keySet = pseudoMap.keySet();
            String targetKey = null;
            for (String key : keySet) {
                if (!prefix.startsWith(key)) continue;
                targetKey = key;
                break;
            }
            if (targetKey == null) {
                return 0;
            }
            evaluatorStack.push(pseudoMap.get(targetKey));
            return targetKey.length();
        }),
        ByNth((chars, pos) -> {
            int last;
            if (pos + 5 >= ((char[])chars).length) {
                return 0;
            }
            String prefix = new String((char[])chars, (int)pos, 5);
            if (!prefix.equals(":nth-")) {
                return 0;
            }
            for (last = pos.intValue(); last < ((char[])chars).length - 1 && chars[last] != ')'; ++last) {
            }
            int count = last - pos + 1;
            String content = new String((char[])chars, (int)pos, count);
            String data = content.substring(content.indexOf("(") + 1, content.lastIndexOf(")"));
            String[] tokens = data.split("n");
            int a = -1;
            int b = -1;
            if (tokens.length == 1) {
                a = 0;
                b = Integer.parseInt(tokens[0]);
            } else if (tokens.length == 2) {
                a = tokens[0].equals("-") ? -1 : Integer.parseInt(tokens[0]);
                b = Integer.parseInt(tokens[1]);
            }
            if (a < 0 && b < 0) {
                return 0;
            }
            Evaluator.CssNthEvaluator structuralEvaluator = null;
            if (content.startsWith(":nth-child(")) {
                structuralEvaluator = new Evaluator.IsNthChild(a, b);
            } else if (content.startsWith(":nth-last-child(")) {
                structuralEvaluator = new Evaluator.IsNthLastChild(a, b);
            } else if (content.startsWith(":nth-of-type(")) {
                structuralEvaluator = new Evaluator.IsNthOfType(a, b);
            } else if (content.startsWith(":nth-last-of-type(")) {
                structuralEvaluator = new Evaluator.IsNthLastOfType(a, b);
            }
            ValidateUtil.checkNotNull(structuralEvaluator, "\u65e0\u6cd5\u8bc6\u522b\u7684\u9009\u62e9\u5668!" + content);
            evaluatorStack.push(structuralEvaluator);
            logger.trace("[\u6dfb\u52a0Nth\u9009\u62e9\u5668]{}", (Object)structuralEvaluator);
            return content.length();
        }),
        ByPseudo((chars, pos) -> {
            int last;
            if (chars[pos] != ':') {
                return 0;
            }
            for (last = pos.intValue(); last < ((char[])chars).length - 1 && chars[last] != ')'; ++last) {
            }
            String content = new String((char[])chars, (int)pos, last - pos + 1);
            String data = content.substring(content.indexOf("(") + 1, content.lastIndexOf(")"));
            Evaluator evaluator = null;
            if (content.contains(":lt")) {
                evaluator = new Evaluator.IndexLessThan(Integer.parseInt(data));
            } else if (content.contains(":gt")) {
                evaluator = new Evaluator.IndexGreaterThan(Integer.parseInt(data));
            } else if (content.contains(":eq")) {
                evaluator = new Evaluator.IndexEquals(Integer.parseInt(data));
            } else if (content.contains(":has")) {
                evaluator = new StructuralEvaluator.Has((Evaluator)evaluatorStack.pop());
            } else if (content.contains(":not")) {
                evaluator = new StructuralEvaluator.Not((Evaluator)evaluatorStack.pop());
            } else if (content.contains(":containsOwn")) {
                evaluator = new Evaluator.ContainsOwnText(data);
            } else if (content.contains(":matchesOwn")) {
                evaluator = new Evaluator.MatchesOwn(Pattern.compile(data));
            } else if (content.contains(":contains")) {
                evaluator = new Evaluator.ContainsText(data);
            } else if (content.contains(":matches")) {
                evaluator = new Evaluator.Matches(Pattern.compile(data));
            }
            ValidateUtil.checkNotNull(evaluator, "\u4e0d\u5408\u6cd5\u7684\u9009\u62e9\u5668!value:" + content);
            evaluatorStack.push(evaluator);
            logger.trace("[\u6dfb\u52a0\u4f2a\u7c7b\u9009\u62e9\u5668]{}", (Object)evaluator);
            return content.length();
        });

        private BiFunction<char[], Integer, Integer> condition;

        private Selector(BiFunction<char[], Integer, Integer> condition) {
            this.condition = condition;
        }
    }
}

