/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.quickhttp.response;

import cn.schoolwow.quickhttp.QuickHttp;
import cn.schoolwow.quickhttp.document.Document;
import cn.schoolwow.quickhttp.document.element.Element;
import cn.schoolwow.quickhttp.document.element.Elements;
import cn.schoolwow.quickhttp.response.Response;
import cn.schoolwow.quickhttp.util.QuickHttpConfig;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractResponse
implements Response {
    private Logger logger = LoggerFactory.getLogger(AbstractResponse.class);
    private HttpURLConnection httpURLConnection;
    private int statusCode;
    private String statusMessage;
    private String charset;
    private Map<String, String> headerMap = new HashMap<String, String>();
    private List<HttpCookie> httpCookieList;
    private BufferedInputStream bufferedInputStream;
    private String body;
    private Document document;

    public AbstractResponse(HttpURLConnection httpURLConnection, int retryTimes) throws IOException {
        this.httpURLConnection = httpURLConnection;
        try {
            this.httpCookieList = QuickHttp.getCookies(httpURLConnection.getURL());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.warn("[Cookie\u83b7\u53d6\u5931\u8d25]\u7f51\u7ad9Cookie\u4fe1\u606f\u83b7\u53d6\u5931\u8d25!url:" + httpURLConnection.getURL());
        }
        if (retryTimes <= 0) {
            retryTimes = QuickHttpConfig.retryTimes;
        }
        int timeout = httpURLConnection.getConnectTimeout();
        for (int i = 0; i <= retryTimes; ++i) {
            try {
                httpURLConnection.setConnectTimeout(timeout);
                httpURLConnection.setReadTimeout(timeout / 2);
                this.statusCode = httpURLConnection.getResponseCode();
                break;
            }
            catch (SocketTimeoutException e) {
                if (i == retryTimes) {
                    throw e;
                }
                if ((timeout *= 2) >= 60000) {
                    timeout = 60000;
                }
                this.logger.warn("[\u94fe\u63a5\u8d85\u65f6]\u7b2c{}\u6b21\u5c1d\u8bd5\u91cd\u8fde,\u603b\u5171{}\u6b21,\u8bbe\u7f6e\u8d85\u65f6\u65f6\u95f4:{},\u5730\u5740:{}", new Object[]{i, retryTimes, timeout, httpURLConnection.getURL()});
                continue;
            }
        }
        this.statusMessage = httpURLConnection.getResponseMessage();
        Map<String, List<String>> headerFields = httpURLConnection.getHeaderFields();
        Set<String> keySet = headerFields.keySet();
        for (String key : keySet) {
            if (key == null) continue;
            this.headerMap.put(key.toLowerCase(), httpURLConnection.getHeaderField(key));
        }
        this.headerMap = Collections.unmodifiableMap(this.headerMap);
        this.logger.debug("[\u83b7\u53d6\u5934\u90e8\u4fe1\u606f]headFields:{}", (Object)JSON.toJSONString(this.headerMap));
        InputStream inputStream = httpURLConnection.getErrorStream() != null ? httpURLConnection.getErrorStream() : httpURLConnection.getInputStream();
        String contentEncoding = this.headerMap.get("content-encoding");
        if (contentEncoding != null && !contentEncoding.isEmpty()) {
            if (contentEncoding.equals("gzip")) {
                this.logger.debug("[\u8fd4\u56degzip\u683c\u5f0f\u6d41]Content-Encoding:{}", (Object)contentEncoding);
                inputStream = new GZIPInputStream(inputStream);
            } else if (contentEncoding.equals("deflate")) {
                this.logger.debug("[\u8fd4\u56dedeflate\u683c\u5f0f\u6d41]Content-Encoding:{}", (Object)contentEncoding);
                inputStream = new InflaterInputStream(inputStream, new Inflater(true));
            }
        }
        this.bufferedInputStream = new BufferedInputStream(inputStream);
        this.getCharset();
        if (this.charset == null) {
            this.charset = "utf-8";
            this.logger.debug("[\u83b7\u53d6charset\u4e3a\u7a7a]\u4f7f\u7528\u9ed8\u8ba4\u7f16\u7801:utf-8");
        } else {
            this.logger.debug("[\u83b7\u53d6charset]charset:{}", (Object)this.charset);
        }
    }

    @Override
    public String url() {
        return this.httpURLConnection.getURL().toString();
    }

    @Override
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    public String statusMessage() {
        return this.statusMessage;
    }

    @Override
    public String charset() {
        return this.charset;
    }

    @Override
    public String contentType() {
        return this.headerMap.get("content-type");
    }

    @Override
    public boolean hasHeader(String name) {
        return this.headerMap.containsKey(name.toLowerCase());
    }

    @Override
    public boolean hasHeaderWithValue(String name, String value) {
        return this.hasHeader(name) && this.headerMap.get(name.toLowerCase()).equals(value);
    }

    @Override
    public String header(String name) {
        return this.headerMap.get(name);
    }

    @Override
    public Map<String, String> headers() {
        return this.headerMap;
    }

    @Override
    public boolean hasCookie(String name) {
        return this.httpCookieList.stream().anyMatch(httpCookie -> httpCookie.getName().equals(name));
    }

    @Override
    public boolean hasCookieWithValue(String name, String value) {
        return this.httpCookieList.stream().anyMatch(httpCookie -> httpCookie.getName().equals(name) && httpCookie.getValue().equals(value));
    }

    @Override
    public HttpCookie cookie(String name) {
        return this.httpCookieList.stream().filter(httpCookie -> httpCookie.getName().equals(name)).findFirst().orElse(null);
    }

    @Override
    public List<HttpCookie> cookieList() {
        return this.httpCookieList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String body() {
        if (this.body != null) {
            return this.body;
        }
        try {
            int length = 0;
            byte[] bytes = new byte[32768];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((length = this.bufferedInputStream.read(bytes, 0, bytes.length)) != -1) {
                baos.write(bytes, 0, length);
            }
            String string = this.body = Charset.forName(this.charset).decode(ByteBuffer.wrap(baos.toByteArray())).toString();
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            this.close();
        }
    }

    @Override
    public JSONObject bodyAsJSONObject() {
        this.body();
        JSONObject object = JSON.parseObject((String)this.body);
        return object;
    }

    @Override
    public JSONArray bodyAsJSONArray() {
        this.body();
        JSONArray array = JSON.parseArray((String)this.body);
        return array;
    }

    @Override
    public JSONObject jsonpAsJSONObject() {
        this.body();
        int startIndex = this.body.indexOf("(") + 1;
        int endIndex = this.body.lastIndexOf(")");
        return JSON.parseObject((String)this.body.substring(startIndex, endIndex));
    }

    @Override
    public JSONArray jsonpAsJSONArray() {
        this.body();
        int startIndex = this.body.indexOf("(") + 1;
        int endIndex = this.body.lastIndexOf(")");
        return JSON.parseArray((String)this.body.substring(startIndex, endIndex));
    }

    @Override
    public byte[] bodyAsBytes() {
        try {
            byte[] byArray = new byte[this.bufferedInputStream.available()];
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
            byte[] byArray = null;
            return byArray;
        }
        finally {
            this.close();
        }
    }

    @Override
    public BufferedInputStream bodyStream() {
        return this.bufferedInputStream;
    }

    @Override
    public Document parse() throws IOException {
        if (this.document == null) {
            if (this.body == null) {
                this.body();
            }
            this.document = Document.parse(this.body);
        }
        return this.document;
    }

    @Override
    public void close() {
        try {
            this.bufferedInputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.httpURLConnection.disconnect();
    }

    private void getCharset() throws IOException {
        String contentType = this.headerMap.get("content-type");
        this.getCharsetFromContentType(contentType);
        if (this.charset == null) {
            byte[] bytes = new byte[5120];
            this.bufferedInputStream.mark(bytes.length);
            this.bufferedInputStream.read(bytes, 0, bytes.length);
            boolean readFully = this.bufferedInputStream.read() == -1;
            this.bufferedInputStream.reset();
            ByteBuffer firstBytes = ByteBuffer.wrap(bytes);
            this.getCharsetFromBOM(firstBytes);
            if (this.charset == null) {
                this.getCharsetFromMeta(firstBytes, readFully);
            }
        }
    }

    private void getCharsetFromMeta(ByteBuffer byteBuffer, boolean readFully) {
        String docData = Charset.forName("utf-8").decode(byteBuffer).toString();
        Document doc = Document.parse(docData);
        if (doc.root() == null) {
            return;
        }
        Elements metaElements = doc.select("meta[http-equiv=content-type], meta[charset]");
        Iterator iterator = metaElements.iterator();
        if (iterator.hasNext()) {
            Element meta = (Element)iterator.next();
            if (meta.hasAttr("http-equiv")) {
                this.getCharsetFromContentType(meta.attr("content"));
            }
            if (this.charset == null && meta.hasAttr("charset")) {
                this.charset = meta.attr("charset");
            }
        }
        if (this.charset == null) {
            Element root = doc.root();
            if (doc.root().tagName().equals("?xml") && root.hasAttr("encoding")) {
                this.charset = root.attr("encoding");
            }
        }
        if (readFully) {
            this.document = doc;
        }
    }

    private void getCharsetFromBOM(ByteBuffer byteBuffer) throws IOException {
        ByteBuffer buffer = byteBuffer;
        ((Buffer)buffer).mark();
        byte[] bom = new byte[4];
        if (byteBuffer.remaining() >= bom.length) {
            byteBuffer.get(bom);
            ((Buffer)buffer).rewind();
        }
        if (bom[0] == 0 && bom[1] == 0 && bom[2] == -2 && bom[3] == -1 || bom[0] == -1 && bom[1] == -2 && bom[2] == 0 && bom[3] == 0) {
            this.charset = "utf-32";
        } else if (bom[0] == -2 && bom[1] == -1 || bom[0] == -1 && bom[1] == -2) {
            this.charset = "utf-16";
        } else if (bom[0] == -17 && bom[1] == -69 && bom[2] == -65) {
            this.charset = "utf-8";
        }
        if (this.charset != null) {
            this.bufferedInputStream.skip(1L);
        }
    }

    private void getCharsetFromContentType(String contentType) {
        int startIndex;
        String prefix = "charset=";
        if (contentType != null && contentType.contains(prefix) && (startIndex = contentType.indexOf(prefix)) >= 0) {
            int endIndex = contentType.lastIndexOf(";");
            if (endIndex > startIndex) {
                this.charset = contentType.substring(startIndex + prefix.length(), endIndex).trim();
            } else if (endIndex < startIndex) {
                this.charset = contentType.substring(startIndex + prefix.length()).trim();
            }
        }
    }
}

