/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.http.sync.job.jst.order;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.sliew.carp.module.http.sync.framework.model.JobSetting;
import cn.sliew.carp.module.http.sync.framework.model.job.JobLogLevel;
import cn.sliew.carp.module.http.sync.framework.model.manager.LockManager;
import cn.sliew.carp.module.http.sync.framework.repository.mapper.JobSyncOffsetMapper;
import cn.sliew.carp.module.http.sync.job.enums.JstJob;
import cn.sliew.carp.module.http.sync.job.jst.AbstractJstJob;
import cn.sliew.carp.module.http.sync.job.remote.JstRemoteService;
import cn.sliew.carp.module.http.sync.job.repository.entity.jst.JstAuth;
import cn.sliew.carp.module.http.sync.job.repository.mapper.jst.JstAuthMapper;
import cn.sliew.carp.module.http.sync.job.repository.mapper.jst.JstOrderMapper;
import cn.sliew.carp.module.http.sync.job.task.jst.AbstractJstRootTask;
import cn.sliew.carp.module.http.sync.job.task.jst.order.JstOrderRootTask;
import cn.sliew.milky.common.check.Ensures;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Date;
import org.apache.pekko.actor.typed.ActorSystem;
import org.apache.pekko.actor.typed.SpawnProtocol;
import org.springframework.stereotype.Component;

@Component
public class JstOrderJob
extends AbstractJstJob {
    private final JstOrderMapper jstOrderMapper;

    public JstOrderJob(ActorSystem<SpawnProtocol.Command> actorSystem, MeterRegistry meterRegistry, JobSyncOffsetMapper jobSyncOffsetMapper, LockManager lockManager, JstRemoteService jstRemoteService, JstAuthMapper jstAuthMapper, JstOrderMapper jstOrderMapper) {
        super(actorSystem, meterRegistry, jobSyncOffsetMapper, lockManager, jstRemoteService, jstAuthMapper);
        this.jstOrderMapper = (JstOrderMapper)Ensures.checkNotNull((Object)jstOrderMapper);
    }

    @Override
    protected JstJob getJstJob() {
        return JstJob.NORMAL_ORDERS_SINGLE_QUERY;
    }

    public JobSetting getSetting(String param) {
        DateTime initSyncOffset = DateUtil.offsetMonth((Date)DateUtil.date(), (int)-1);
        DateTime finalSyncOffset = DateUtil.offsetHour((Date)DateUtil.date(), (int)-1);
        return JobSetting.builder().jobInfo(this.getJobInfo(param)).logLevel(JobLogLevel.COMPLEX).initSyncOffset(DateUtil.format((Date)initSyncOffset, (String)"yyyy-MM-dd HH:mm:ss")).finalSyncOffset(DateUtil.format((Date)finalSyncOffset, (String)"yyyy-MM-dd HH:mm:ss")).dispatcher("pekko.actor.http-job-dispatcher").parallelism(Integer.valueOf(2)).batchSize(Integer.valueOf(100)).build();
    }

    @Override
    protected AbstractJstRootTask buildJstRootTask(JstAuth jstAuth) {
        return new JstOrderRootTask(System.currentTimeMillis(), this.jstRemoteService, jstAuth, this.jstOrderMapper);
    }
}

