/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.http.sync.job.remote;

import cn.sliew.carp.module.http.sync.job.repository.entity.jst.JstAuth;
import cn.sliew.carp.module.http.sync.job.repository.mapper.jst.JstAuthMapper;
import cn.sliew.carp.module.http.sync.job.util.ApiUtil;
import cn.sliew.carp.module.http.sync.remote.jst.api.JstOrderClient;
import cn.sliew.carp.module.http.sync.remote.jst.request.order.OrdersSingleQuery;
import cn.sliew.carp.module.http.sync.remote.jst.response.JstNewResult;
import cn.sliew.carp.module.http.sync.remote.jst.response.order.JstOrdersResult;
import cn.sliew.milky.common.util.JacksonUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.base.Joiner;
import java.net.URI;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JstRemoteService {
    private URI uri = URI.create("https://api.jushuitan.com/");
    @Autowired
    private JstAuthMapper jstAuthMapper;
    @Autowired
    private JstOrderClient jstOrderClient;

    private String sign(JstAuth auth, String param) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_key", auth.getAppKey());
        params.put("access_token", auth.getAccessToken());
        params.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        params.put("version", "2");
        params.put("charset", "utf-8");
        params.put("biz", param);
        String sign = ApiUtil.getSign(auth.getAppSecret(), params);
        params.put("sign", sign);
        return Joiner.on((String)"&").withKeyValueSeparator("=").join(params);
    }

    private JstAuth getAuth(String appKey, String company) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(JstAuth.class).eq(JstAuth::getAppKey, (Object)appKey)).eq(JstAuth::getCompany, (Object)company);
        return (JstAuth)((Object)this.jstAuthMapper.selectOne((Wrapper)queryWrapper));
    }

    public JstNewResult<JstOrdersResult> getOrders(JstAuth auth, OrdersSingleQuery query) {
        return this.jstOrderClient.getOrders(this.uri, this.sign(auth, JacksonUtil.toJsonString((Object)query)));
    }
}

