/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.cache.caffeine;

import cn.sliew.milky.cache.CacheOptions;
import cn.sliew.milky.common.check.Ensures;
import java.time.Duration;
import java.util.Objects;

public class CaffeineCacheOptions<K, V>
extends CacheOptions<K, V> {
    private Integer initialCapacity = 4;
    private Long maximumSize = 20L;
    private Long maximumWeight = 0L;
    private Boolean weakKeys = false;
    private Boolean weakValues = false;
    private Boolean softValues = false;
    private Duration expireAfterAccess = Duration.ofSeconds(60L);
    private Duration expireAfterWrite = Duration.ofSeconds(45L);
    private Duration refreshAfterWrite = Duration.ofSeconds(30L);

    public CaffeineCacheOptions<K, V> initialCapacity(int initialCapacity) {
        Ensures.checkArgument(initialCapacity > 0, () -> String.format("cache initialCapacity invalid: %d", initialCapacity));
        this.initialCapacity = initialCapacity;
        return this;
    }

    public int getInitialCapacity() {
        return this.initialCapacity;
    }

    public CaffeineCacheOptions<K, V> maximumSize(long maximumSize) {
        Ensures.checkArgument(maximumSize > 0L, () -> String.format("cache maximumSize invalid: %d", maximumSize));
        this.maximumSize = maximumSize;
        return this;
    }

    public long getMaximumSize() {
        return this.maximumSize;
    }

    public CaffeineCacheOptions<K, V> maximumWeight(long maximumWeight) {
        Ensures.checkArgument(maximumWeight > 0L, () -> String.format("cache maximumWeight invalid: %d", maximumWeight));
        this.maximumWeight = maximumWeight;
        return this;
    }

    public long getMaximumWeight() {
        return this.maximumWeight;
    }

    public CaffeineCacheOptions<K, V> weakKeys(boolean weakKeys) {
        this.weakKeys = weakKeys;
        return this;
    }

    public boolean isWeakKeys() {
        return this.weakKeys;
    }

    public CaffeineCacheOptions<K, V> weakValues(boolean weakValues) {
        this.weakValues = weakValues;
        return this;
    }

    public boolean isWeakValues() {
        return this.weakValues;
    }

    public CaffeineCacheOptions<K, V> softValues(boolean softValues) {
        this.softValues = softValues;
        return this;
    }

    public boolean isSoftValues() {
        return this.softValues;
    }

    public CaffeineCacheOptions<K, V> expireAfterAccess(Duration expireAfterAccess) {
        Ensures.checkNotNull(expireAfterAccess, () -> "cache refreshAfterWrite can't be null");
        this.expireAfterAccess = expireAfterAccess;
        return this;
    }

    public Duration getExpireAfterAccess() {
        return this.expireAfterAccess;
    }

    public CaffeineCacheOptions<K, V> expireAfterWrite(Duration expireAfterWrite) {
        Ensures.checkNotNull(expireAfterWrite, () -> "cache expireAfterWrite can't be null");
        this.expireAfterWrite = expireAfterWrite;
        return this;
    }

    public Duration getExpireAfterWrite() {
        return this.expireAfterWrite;
    }

    public CaffeineCacheOptions<K, V> refreshAfterWrite(Duration refreshAfterWrite) {
        Ensures.checkNotNull(refreshAfterWrite, () -> "cache refreshAfterWrite can't be null");
        this.refreshAfterWrite = refreshAfterWrite;
        return this;
    }

    public Duration getRefreshAfterWrite() {
        return this.refreshAfterWrite;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CaffeineCacheOptions that = (CaffeineCacheOptions)o;
        return Objects.equals(this.initialCapacity, that.initialCapacity) && Objects.equals(this.maximumSize, that.maximumSize) && Objects.equals(this.maximumWeight, that.maximumWeight) && Objects.equals(this.weakKeys, that.weakKeys) && Objects.equals(this.weakValues, that.weakValues) && Objects.equals(this.softValues, that.softValues) && Objects.equals(this.expireAfterAccess, that.expireAfterAccess) && Objects.equals(this.expireAfterWrite, that.expireAfterWrite) && Objects.equals(this.refreshAfterWrite, that.refreshAfterWrite);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.initialCapacity, this.maximumSize, this.maximumWeight, this.weakKeys, this.weakValues, this.softValues, this.expireAfterAccess, this.expireAfterWrite, this.refreshAfterWrite);
    }
}

