/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.cache.lettuce;

import cn.sliew.milky.cache.Cache;
import cn.sliew.milky.cache.CacheLoader;
import cn.sliew.milky.cache.lettuce.DefaultLettuceConnectionFactory;
import cn.sliew.milky.cache.lettuce.LettuceCacheOptions;
import cn.sliew.milky.cache.lettuce.LettuceCommandsWrapper;
import cn.sliew.milky.cache.lettuce.LettuceConnectionFactory;
import cn.sliew.milky.common.check.Ensures;
import cn.sliew.milky.common.exception.Rethrower;
import cn.sliew.milky.log.Logger;
import cn.sliew.milky.log.LoggerFactory;
import io.lettuce.core.Limit;
import io.lettuce.core.Range;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.metrics.CommandLatencyRecorder;
import io.lettuce.core.metrics.MicrometerCommandLatencyRecorder;
import io.lettuce.core.metrics.MicrometerOptions;
import io.lettuce.core.resource.ClientResources;
import io.lettuce.core.support.BoundedPoolConfig;
import io.micrometer.core.instrument.MeterRegistry;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.StreamSupport;

public class LettuceCache<K, V>
implements Cache<K, V> {
    private static final Logger log = LoggerFactory.getLogger(LettuceCache.class);
    private final HashedWheelTimer timer;
    private DefaultLettuceConnectionFactory connectionFactory;
    private final LettuceCacheOptions<K, V> options;

    public LettuceCache(LettuceCacheOptions<K, V> options) {
        this.options = Ensures.checkNotNull(options, () -> "options can't be null");
        this.connect(ClientResources.create());
        this.timer = new HashedWheelTimer(1L, TimeUnit.SECONDS, 64);
        this.timer.newTimeout((TimerTask)new ExpireTimeTask(), 1L, TimeUnit.SECONDS);
        this.timer.start();
    }

    @Override
    public String name() {
        return this.options.getName();
    }

    private String hashKey() {
        return this.name() + "_hash";
    }

    private String sortsetKey() {
        return this.name() + "_sortset";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public V get(K key) {
        try (LettuceConnectionFactory.LettuceConnection connection = this.connectionFactory.getConnection();){
            LettuceCommandsWrapper commandsWrapper = connection.sync();
            ValueWrapper valueWrapper = (ValueWrapper)commandsWrapper.hget(this.hashKey(), key);
            if (valueWrapper == null) {
                V v = null;
                return v;
            }
            if (valueWrapper.getExpireAt() <= System.nanoTime()) {
                this.remove(key);
                V v = null;
                return v;
            }
            Object v = valueWrapper.getValue();
            return v;
        }
        catch (IOException e) {
            Rethrower.throwAs(e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean containsKey(K key) {
        try (LettuceConnectionFactory.LettuceConnection connection = this.connectionFactory.getConnection();){
            LettuceCommandsWrapper commandsWrapper = connection.sync();
            if (commandsWrapper.hexists(this.hashKey(), key).booleanValue()) {
                ValueWrapper valueWrapper = (ValueWrapper)commandsWrapper.hget(this.hashKey(), key);
                if (valueWrapper.getExpireAt() <= System.nanoTime()) {
                    this.remove(key);
                    boolean bl = false;
                    return bl;
                }
                boolean bl = valueWrapper.getValue() != null;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            Rethrower.throwAs(e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V computeIfAbsent(K key, CacheLoader<K, V> loader, Duration expire) {
        V value = this.get(key);
        if (value == null) {
            DefaultLettuceConnectionFactory defaultLettuceConnectionFactory = this.connectionFactory;
            synchronized (defaultLettuceConnectionFactory) {
                value = this.get(key);
                if (value == null) {
                    try {
                        value = loader.load(key);
                        this.put(key, value, expire);
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), e);
                    }
                }
            }
        }
        return value;
    }

    @Override
    public void put(K key, V value) {
        try (LettuceConnectionFactory.LettuceConnection connection = this.connectionFactory.getConnection();){
            LettuceCommandsWrapper commandsWrapper = connection.sync();
            commandsWrapper.zadd(this.sortsetKey(), 9.223372036854776E18, value);
            commandsWrapper.hset(this.hashKey(), key, new ValueWrapper<V>(value, Long.MAX_VALUE));
        }
        catch (IOException e) {
            Rethrower.throwAs(e);
        }
    }

    @Override
    public void put(K key, V value, Duration expire) {
        try (LettuceConnectionFactory.LettuceConnection connection = this.connectionFactory.getConnection();){
            LettuceCommandsWrapper commandsWrapper = connection.sync();
            long expireAt = expire.toNanos() + System.nanoTime();
            commandsWrapper.zadd(this.sortsetKey(), expireAt, value);
            commandsWrapper.hset(this.hashKey(), key, new ValueWrapper<V>(value, expireAt));
        }
        catch (IOException e) {
            Rethrower.throwAs(e);
        }
    }

    @Override
    public void remove(K key) {
        try (LettuceConnectionFactory.LettuceConnection connection = this.connectionFactory.getConnection();){
            LettuceCommandsWrapper commandsWrapper = connection.sync();
            commandsWrapper.hdel(this.hashKey(), key);
            commandsWrapper.zrem(this.sortsetKey(), key);
        }
        catch (IOException e) {
            Rethrower.throwAs(e);
        }
    }

    @Override
    public void removeAll(Iterable<K> keys) {
        try (LettuceConnectionFactory.LettuceConnection connection = this.connectionFactory.getConnection();){
            LettuceCommandsWrapper commandsWrapper = connection.sync();
            Object[] array = StreamSupport.stream(keys.spliterator(), false).toArray();
            commandsWrapper.hdel(this.hashKey(), array);
            commandsWrapper.zrem(this.sortsetKey(), array);
        }
        catch (IOException e) {
            Rethrower.throwAs(e);
        }
    }

    @Override
    public long size() {
        long l;
        block8: {
            LettuceConnectionFactory.LettuceConnection connection = this.connectionFactory.getConnection();
            try {
                LettuceCommandsWrapper commandsWrapper = connection.sync();
                l = commandsWrapper.zcard(this.sortsetKey());
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Rethrower.throwAs(e);
                    return 0L;
                }
            }
            connection.close();
        }
        return l;
    }

    @Override
    public boolean supportNullKey() {
        return false;
    }

    @Override
    public boolean supportNullValue() {
        return true;
    }

    @Override
    public Iterator<K> keyIterator() {
        Iterator<String> iterator;
        block8: {
            LettuceConnectionFactory.LettuceConnection connection = this.connectionFactory.getConnection();
            try {
                LettuceCommandsWrapper commandsWrapper = connection.sync();
                iterator = commandsWrapper.hkeys(this.hashKey()).iterator();
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Rethrower.throwAs(e);
                    return null;
                }
            }
            connection.close();
        }
        return iterator;
    }

    @Override
    public Iterator<K> hotKeyIterator(int n) {
        return Collections.emptyIterator();
    }

    @Override
    public void stats(MeterRegistry registry) {
        MicrometerOptions options = MicrometerOptions.create();
        ClientResources resources = ClientResources.builder().commandLatencyRecorder((CommandLatencyRecorder)new MicrometerCommandLatencyRecorder(registry, options)).build();
        this.connect(resources);
    }

    @Override
    public void clear() {
        try (LettuceConnectionFactory.LettuceConnection connection = this.connectionFactory.getConnection();){
            LettuceCommandsWrapper commandsWrapper = connection.sync();
            commandsWrapper.del(this.hashKey());
            commandsWrapper.del(this.sortsetKey());
        }
        catch (IOException e) {
            Rethrower.throwAs(e);
        }
    }

    @Override
    public void destroy() {
    }

    private void connect(ClientResources resources) {
        List<RedisURI> clusterRedisURIS = this.options.getClusterRedisURIS();
        if (clusterRedisURIS != null && !clusterRedisURIS.isEmpty()) {
            RedisClusterClient clusterClient = RedisClusterClient.create((ClientResources)resources, clusterRedisURIS);
            this.connectionFactory = new DefaultLettuceConnectionFactory(clusterClient, BoundedPoolConfig.create());
        } else {
            this.connectionFactory = new DefaultLettuceConnectionFactory(RedisClient.create((ClientResources)resources, (RedisURI)this.options.getRedisURI()), BoundedPoolConfig.create());
        }
    }

    public static class ValueWrapper<V> {
        private final V value;
        private final long expireAt;

        public ValueWrapper(V value, long expireAt) {
            this.value = value;
            this.expireAt = expireAt;
        }

        public V getValue() {
            return this.value;
        }

        public long getExpireAt() {
            return this.expireAt;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ValueWrapper that = (ValueWrapper)o;
            return this.expireAt == that.expireAt && Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.value, this.expireAt);
        }
    }

    private class ExpireTimeTask
    implements TimerTask {
        private ExpireTimeTask() {
        }

        public void run(Timeout timeout) throws Exception {
            List keys;
            LettuceConnectionFactory.LettuceConnection connection = LettuceCache.this.connectionFactory.getConnection();
            LettuceCommandsWrapper commandsWrapper = connection.sync();
            if (commandsWrapper.exists(LettuceCache.this.sortsetKey()) == 0L) {
                LettuceCache.this.clear();
            }
            if ((keys = commandsWrapper.zrangebyscore(LettuceCache.this.sortsetKey(), (Range<Number>)Range.create((Object)0, (Object)System.nanoTime()), Limit.from((long)100L))) != null && keys.size() > 0) {
                LettuceCache.this.removeAll(keys);
            }
            LocalDateTime tomorrow = LocalDateTime.now().withNano(0).withSecond(0).withMinute(0).withHour(3).plusDays(1L);
            Instant instant = tomorrow.atZone(ZoneOffset.systemDefault()).toInstant();
            if (commandsWrapper.ttl(LettuceCache.this.hashKey()) == -1L) {
                commandsWrapper.expireat(LettuceCache.this.hashKey(), Date.from(instant));
            }
            if (commandsWrapper.ttl(LettuceCache.this.sortsetKey()) == -1L) {
                commandsWrapper.expireat(LettuceCache.this.sortsetKey(), Date.from(instant));
            }
            LettuceCache.this.timer.newTimeout((TimerTask)this, 1L, TimeUnit.SECONDS);
        }
    }
}

