/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.cache.ohc;

import cn.sliew.milky.cache.CacheOptions;
import cn.sliew.milky.cache.ohc.ProtostuffCacheSerializer;
import cn.sliew.milky.common.check.Ensures;
import java.util.Objects;
import org.caffinitas.ohc.CacheSerializer;
import org.caffinitas.ohc.Eviction;
import org.caffinitas.ohc.HashAlgorithm;
import org.caffinitas.ohc.Ticker;

public class OhcCacheOptions<K, V>
extends CacheOptions<K, V> {
    private Integer segmentCount;
    private Integer hashTableSize = 8192;
    private Long capacity;
    private Integer chunkSize;
    private CacheSerializer<K> keySerializer = ProtostuffCacheSerializer.INSTANCE;
    private CacheSerializer<V> valueSerializer = ProtostuffCacheSerializer.INSTANCE;
    private Float loadFactor = Float.valueOf(0.75f);
    private Integer fixedKeySize;
    private Integer fixedValueSize;
    private Long maxEntrySize;
    private Boolean throwOOME;
    private HashAlgorithm hashAlgorighm = HashAlgorithm.MURMUR3;
    private Boolean unlocked;
    private Long defaultTTLmillis = 60000L;
    private Boolean timeouts = true;
    private Integer timeoutsSlots;
    private Integer timeoutsPrecision;
    private Ticker ticker = Ticker.DEFAULT;
    private Eviction eviction = Eviction.W_TINY_LFU;
    private Integer frequencySketchSize;
    private Double edenSize = 0.2;

    public OhcCacheOptions<K, V> segmentCount(int segmentCount) {
        Ensures.checkArgument(segmentCount > 0, () -> String.format("cache segmentCount invalid: %d", segmentCount));
        this.segmentCount = segmentCount;
        return this;
    }

    public Integer getSegmentCount() {
        return this.segmentCount;
    }

    public OhcCacheOptions<K, V> hashTableSize(int hashTableSize) {
        Ensures.checkArgument(hashTableSize > 0, () -> String.format("cache hashTableSize invalid: %d", hashTableSize));
        this.hashTableSize = hashTableSize;
        return this;
    }

    public Integer getHashTableSize() {
        return this.hashTableSize;
    }

    public OhcCacheOptions<K, V> capacity(long capacity) {
        Ensures.checkArgument(capacity > 0L, () -> String.format("cache capacity invalid: %d", capacity));
        this.capacity = capacity;
        return this;
    }

    public Long getCapacity() {
        return this.capacity;
    }

    public OhcCacheOptions<K, V> chunkSize(int chunkSize) {
        Ensures.checkArgument(chunkSize > 0, () -> String.format("cache chunkSize invalid: %d", chunkSize));
        this.chunkSize = chunkSize;
        return this;
    }

    public Integer getChunkSize() {
        return this.chunkSize;
    }

    public OhcCacheOptions<K, V> keySerializer(CacheSerializer<K> keySerializer) {
        Ensures.checkNotNull(keySerializer, () -> "cache keySerializer can't be null");
        this.keySerializer = keySerializer;
        return this;
    }

    public CacheSerializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    public OhcCacheOptions<K, V> valueSerializer(CacheSerializer<V> valueSerializer) {
        Ensures.checkNotNull(valueSerializer, () -> "cache valueSerializer can't be null");
        this.valueSerializer = valueSerializer;
        return this;
    }

    public CacheSerializer<V> getValueSerializer() {
        return this.valueSerializer;
    }

    public OhcCacheOptions<K, V> loadFactor(Float loadFactor) {
        Ensures.checkArgument(loadFactor.floatValue() > 0.0f, () -> String.format("cache loadFactor invalid: %d", loadFactor));
        this.loadFactor = loadFactor;
        return this;
    }

    public Float getLoadFactor() {
        return this.loadFactor;
    }

    public OhcCacheOptions<K, V> fixedKeySize(Integer fixedKeySize) {
        Ensures.checkArgument(fixedKeySize > 0, () -> String.format("cache fixedKeySize invalid: %d", fixedKeySize));
        this.fixedKeySize = fixedKeySize;
        return this;
    }

    public Integer getFixedKeySize() {
        return this.fixedKeySize;
    }

    public OhcCacheOptions<K, V> fixedValueSize(Integer fixedValueSize) {
        Ensures.checkArgument(fixedValueSize > 0, () -> String.format("cache fixedValueSize invalid: %d", fixedValueSize));
        this.fixedValueSize = fixedValueSize;
        return this;
    }

    public Integer getFixedValueSize() {
        return this.fixedValueSize;
    }

    public OhcCacheOptions<K, V> maxEntrySize(Long maxEntrySize) {
        Ensures.checkArgument(maxEntrySize > 0L, () -> String.format("cache maxEntrySize invalid: %d", maxEntrySize));
        this.maxEntrySize = maxEntrySize;
        return this;
    }

    public Long getMaxEntrySize() {
        return this.maxEntrySize;
    }

    public OhcCacheOptions<K, V> throwOOME(Boolean throwOOME) {
        Ensures.checkNotNull(throwOOME, () -> "cache throwOOME can't be null");
        this.throwOOME = throwOOME;
        return this;
    }

    public Boolean getThrowOOME() {
        return this.throwOOME;
    }

    public OhcCacheOptions<K, V> hashAlgorighm(HashAlgorithm hashAlgorighm) {
        Ensures.checkNotNull(hashAlgorighm, () -> "cache hashAlgorighm can't be null");
        this.hashAlgorighm = hashAlgorighm;
        return this;
    }

    public HashAlgorithm getHashAlgorighm() {
        return this.hashAlgorighm;
    }

    public OhcCacheOptions<K, V> unlocked(Boolean unlocked) {
        Ensures.checkNotNull(unlocked, () -> "cache unlocked can't be null");
        this.unlocked = unlocked;
        return this;
    }

    public Boolean getUnlocked() {
        return this.unlocked;
    }

    public OhcCacheOptions<K, V> defaultTTLmillis(Long defaultTTLmillis) {
        Ensures.checkArgument(defaultTTLmillis > 0L, () -> String.format("cache defaultTTLmillis invalid: %d", defaultTTLmillis));
        this.defaultTTLmillis = defaultTTLmillis;
        return this;
    }

    public Long getDefaultTTLmillis() {
        return this.defaultTTLmillis;
    }

    public OhcCacheOptions<K, V> timeouts(Boolean timeouts) {
        Ensures.checkNotNull(timeouts, () -> "cache timeouts can't be null");
        this.timeouts = timeouts;
        return this;
    }

    public Boolean getTimeouts() {
        return this.timeouts;
    }

    public OhcCacheOptions<K, V> timeoutsSlots(Integer timeoutsSlots) {
        Ensures.checkArgument(timeoutsSlots > 0, () -> String.format("cache timeoutsSlots invalid: %d", timeoutsSlots));
        this.timeoutsSlots = timeoutsSlots;
        return this;
    }

    public Integer getTimeoutsSlots() {
        return this.timeoutsSlots;
    }

    public OhcCacheOptions<K, V> timeoutsPrecision(Integer timeoutsPrecision) {
        Ensures.checkArgument(timeoutsPrecision > 0, () -> String.format("cache timeoutsPrecision invalid: %d", timeoutsPrecision));
        this.timeoutsPrecision = timeoutsPrecision;
        return this;
    }

    public Integer getTimeoutsPrecision() {
        return this.timeoutsPrecision;
    }

    public OhcCacheOptions<K, V> ticker(Ticker ticker) {
        Ensures.checkNotNull(ticker, () -> "cache ticker can't be null");
        this.ticker = ticker;
        return this;
    }

    public Ticker getTicker() {
        return this.ticker;
    }

    public OhcCacheOptions<K, V> ticker(Eviction eviction) {
        Ensures.checkNotNull(eviction, () -> "cache eviction can't be null");
        this.eviction = eviction;
        return this;
    }

    public Eviction getEviction() {
        return this.eviction;
    }

    public OhcCacheOptions<K, V> frequencySketchSize(Integer frequencySketchSize) {
        Ensures.checkArgument(frequencySketchSize > 0, () -> String.format("cache frequencySketchSize invalid: %d", frequencySketchSize));
        this.frequencySketchSize = frequencySketchSize;
        return this;
    }

    public Integer getFrequencySketchSize() {
        return this.frequencySketchSize;
    }

    public OhcCacheOptions<K, V> edenSize(Double edenSize) {
        Ensures.checkArgument(edenSize > 0.0, () -> String.format("cache edenSize invalid: %d", edenSize));
        this.edenSize = edenSize;
        return this;
    }

    public Double getEdenSize() {
        return this.edenSize;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OhcCacheOptions that = (OhcCacheOptions)o;
        return Objects.equals(this.segmentCount, that.segmentCount) && Objects.equals(this.hashTableSize, that.hashTableSize) && Objects.equals(this.capacity, that.capacity) && Objects.equals(this.chunkSize, that.chunkSize) && Objects.equals(this.keySerializer, that.keySerializer) && Objects.equals(this.valueSerializer, that.valueSerializer) && Objects.equals(this.loadFactor, that.loadFactor) && Objects.equals(this.fixedKeySize, that.fixedKeySize) && Objects.equals(this.fixedValueSize, that.fixedValueSize) && Objects.equals(this.maxEntrySize, that.maxEntrySize) && Objects.equals(this.throwOOME, that.throwOOME) && this.hashAlgorighm == that.hashAlgorighm && Objects.equals(this.unlocked, that.unlocked) && Objects.equals(this.defaultTTLmillis, that.defaultTTLmillis) && Objects.equals(this.timeouts, that.timeouts) && Objects.equals(this.timeoutsSlots, that.timeoutsSlots) && Objects.equals(this.timeoutsPrecision, that.timeoutsPrecision) && Objects.equals(this.ticker, that.ticker) && this.eviction == that.eviction && Objects.equals(this.frequencySketchSize, that.frequencySketchSize) && Objects.equals(this.edenSize, that.edenSize);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.segmentCount, this.hashTableSize, this.capacity, this.chunkSize, this.keySerializer, this.valueSerializer, this.loadFactor, this.fixedKeySize, this.fixedValueSize, this.maxEntrySize, this.throwOOME, this.hashAlgorighm, this.unlocked, this.defaultTTLmillis, this.timeouts, this.timeoutsSlots, this.timeoutsPrecision, this.ticker, this.eviction, this.frequencySketchSize, this.edenSize);
    }
}

