/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.cache.ohc;

import com.google.common.base.Charsets;
import java.nio.ByteBuffer;
import org.caffinitas.ohc.CacheSerializer;

public class StringCacheSerializer
implements CacheSerializer<String> {
    public static final StringCacheSerializer INSTANCE = new StringCacheSerializer();

    public int serializedSize(String value) {
        byte[] bytes = value.getBytes(Charsets.UTF_8);
        if (bytes.length > 65536) {
            throw new RuntimeException("encoded string too long: " + bytes.length + " bytes");
        }
        return bytes.length + 2;
    }

    public void serialize(String value, ByteBuffer buf) {
        byte[] bytes = value.getBytes(Charsets.UTF_8);
        buf.put((byte)(bytes.length >>> 8 & 0xFF));
        buf.put((byte)(bytes.length & 0xFF));
        buf.put(bytes);
    }

    public String deserialize(ByteBuffer buf) {
        int length = ((buf.get() & 0xFF) << 8) + (buf.get() & 0xFF);
        byte[] bytes = new byte[length];
        buf.get(bytes);
        return new String(bytes, Charsets.UTF_8);
    }
}

