/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.common.constant;

import cn.sliew.milky.common.check.Ensures;
import cn.sliew.milky.common.constant.Constant;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class ConstantPool<T extends Constant<T>> {
    private final ConcurrentMap<String, T> constants = new ConcurrentHashMap<String, T>();
    private final AtomicInteger nextId = new AtomicInteger(1);

    public T valueOf(Class<?> firstNameComponent, String secondNameComponent) {
        Ensures.checkNotNull(firstNameComponent, () -> "firstNameComponent null");
        Ensures.checkNotNull(secondNameComponent, () -> "secondNameComponent null");
        return this.valueOf(firstNameComponent.getName() + "#" + secondNameComponent);
    }

    public T valueOf(String name) {
        Ensures.notBlank(name, () -> "name null or empty");
        return this.getOrCreate(name);
    }

    private T getOrCreate(String name) {
        T tempConstant;
        Constant constant = (Constant)this.constants.get(name);
        if (constant == null && (constant = (Constant)this.constants.putIfAbsent(name, tempConstant = this.newConstant(this.nextId(), name))) == null) {
            return tempConstant;
        }
        return (T)constant;
    }

    public boolean exists(String name) {
        Ensures.notBlank(name, () -> "name null or empty");
        return this.constants.containsKey(name);
    }

    public T newInstance(String name) {
        Ensures.notBlank(name, () -> "name null or empty");
        return this.createOrThrow(name);
    }

    private T createOrThrow(String name) {
        T tempConstant;
        Constant constant = (Constant)this.constants.get(name);
        if (constant == null && (constant = (Constant)this.constants.putIfAbsent(name, tempConstant = this.newConstant(this.nextId(), name))) == null) {
            return tempConstant;
        }
        throw new IllegalArgumentException(String.format("'%s' is already in use", name));
    }

    protected abstract T newConstant(int var1, String var2);

    @Deprecated
    public final int nextId() {
        return this.nextId.getAndIncrement();
    }
}

