/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.milky.common.environment;

import cn.sliew.milky.common.check.Ensures;
import cn.sliew.milky.common.environment.PropertyResolver;
import cn.sliew.milky.common.parse.placeholder.PropertyPlaceholder;
import cn.sliew.milky.log.Logger;
import cn.sliew.milky.log.LoggerFactory;
import java.util.Optional;
import java.util.function.Function;

public abstract class AbstractPropertyResolver
implements PropertyResolver {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private Optional<PropertyPlaceholder> nonStrictHelper;
    private Optional<PropertyPlaceholder> strictHelper;
    private boolean ignoreUnresolvableNestedPlaceholders = false;
    private String placeholderPrefix = "${";
    private String placeholderSuffix = "}";
    private String valueSeparator = ":";

    @Override
    public boolean containsProperty(String key) {
        return this.getProperty(key).isPresent();
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        return this.getProperty(key).orElse(defaultValue);
    }

    @Override
    public <R, T> T getProperty(String key, Function<R, T> mappingFunction, T defaultValue) {
        return this.getProperty(key, mappingFunction).orElse(defaultValue);
    }

    @Override
    public String getRequiredProperty(String key) throws IllegalStateException {
        return this.getProperty(key).orElseThrow(() -> new IllegalStateException("Required key '" + key + "' not found"));
    }

    @Override
    public <R, T> T getRequiredProperty(String key, Function<R, T> mappingFunction) throws IllegalStateException {
        return this.getProperty(key, mappingFunction).orElseThrow(() -> new IllegalStateException("Required key '" + key + "' not found"));
    }

    @Override
    public String resolvePlaceholders(String text) {
        if (!this.nonStrictHelper.isPresent()) {
            this.nonStrictHelper = Optional.of(this.createPlaceholderHelper(true));
        }
        return this.doResolvePlaceholders(text, this.nonStrictHelper.get());
    }

    @Override
    public String resolveRequiredPlaceholders(String text) throws IllegalArgumentException {
        if (!this.strictHelper.isPresent()) {
            this.strictHelper = Optional.of(this.createPlaceholderHelper(false));
        }
        return this.doResolvePlaceholders(text, this.nonStrictHelper.get());
    }

    protected String resolveNestedPlaceholders(String value) {
        if (value.isEmpty()) {
            return value;
        }
        return this.ignoreUnresolvableNestedPlaceholders ? this.resolvePlaceholders(value) : this.resolveRequiredPlaceholders(value);
    }

    private PropertyPlaceholder createPlaceholderHelper(boolean ignoreUnresolvablePlaceholders) {
        return new PropertyPlaceholder(this.log, this.placeholderPrefix, this.placeholderSuffix, this.valueSeparator, ignoreUnresolvablePlaceholders);
    }

    private String doResolvePlaceholders(String text, PropertyPlaceholder helper) {
        return helper.replacePlaceholders(text, new PropertyPlaceholder.PlaceholderResolver(){

            @Override
            public Optional<String> resolvePlaceholder(String placeholderName) {
                return AbstractPropertyResolver.this.getPropertyAsRawString(placeholderName);
            }

            @Override
            public boolean shouldIgnoreMissing(String placeholderName) {
                return true;
            }

            @Override
            public boolean shouldRemoveMissingPlaceholder(String placeholderName) {
                return false;
            }
        });
    }

    @Override
    public void setPlaceholderPrefix(String placeholderPrefix) {
        this.placeholderPrefix = Ensures.notBlank(placeholderPrefix, () -> "'placeholderPrefix' must not be blank");
    }

    @Override
    public void setPlaceholderSuffix(String placeholderSuffix) {
        this.placeholderSuffix = Ensures.notBlank(placeholderSuffix, () -> "'placeholderSuffix' must not be blank");
    }

    @Override
    public void setValueSeparator(String valueSeparator) {
        this.placeholderSuffix = Ensures.notBlank(valueSeparator, () -> "'valueSeparator' must not be blank");
    }

    protected abstract Optional<String> getPropertyAsRawString(String var1);
}

